/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.client.PSGeneric;

import java.util.List;
import org.ow2.choreos.xsa.xsb.client.PSGeneric.BrokerSystem;
import org.ow2.choreos.xsa.xsb.client.PSGeneric.PSScope;
import org.ow2.choreos.xsa.xsb.clients.generic.CallbackSystem;
import org.ow2.choreos.xsa.xsb.clients.generic.ICallbackScope;
import org.ow2.choreos.xsa.xsb.clients.generic.IProxyScope;
import org.ow2.choreos.xsa.xsb.clients.generic.ProxySystem;
import org.ow2.choreos.xsa.xsb.clients.generic.System;
import org.ow2.choreos.xsa.xsb.clients.generic.exceptions.SystemException;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TMode;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.PSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.TFilter;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.TFilterSemantic;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.TPSDLScopes;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.utils.CachedPSDLDefinition;

public abstract class PSSystem<IO, D extends CachedPSDLDefinition<?>, D2 extends TScopeID, C extends ICallbackScope, P extends IProxyScope>
extends System<IO, D, PSScope<C, P>> {
    protected CallbackSystem<IO, D, D2, TSubscopeID, C> listenersPart;
    protected ProxySystem<IO, D, P> clientsPart;
    protected ProxySystem<IO, D, P> externalPart;
    protected BrokerSystem<D> brokerPart = this.buildBrokerPart();

    public PSSystem(D definition) throws SystemException {
        super(definition);
        this.clientsPart = this.buildProviderPart();
        this.externalPart = this.buildExternalPart();
        this.listenersPart = this.buildListenersPart();
        this.buildScopes(definition);
    }

    protected abstract BrokerSystem<D> buildBrokerPart();

    protected abstract CallbackSystem<IO, D, D2, TSubscopeID, C> buildListenersPart() throws SystemException;

    protected abstract ProxySystem<IO, D, P> buildProviderPart() throws SystemException;

    protected abstract ProxySystem<IO, D, P> buildExternalPart() throws SystemException;

    public void buildScopes(D definition) throws SystemException {
        TPSDLScopes scopes = (TPSDLScopes)((PSDLDefinition)definition.getDefinition()).getScopes().getValue();
        int i = 0;
        for (TFilter filter : scopes.getFilter()) {
            TScopeID filterId = (TScopeID)filter.getScopeId().getValue();
            PSScope scope = new PSScope(filterId.getId(), this);
            List semantics = filter.getSemantic();
            if (semantics.contains(TFilterSemantic.PUBLISH)) {
                C callback = this.buildListener(filterId);
                scope.add((Object)callback);
                this.listenersPart.addCallback(filterId, null, callback);
            }
            if (semantics.contains(TFilterSemantic.SUBSCRIBE)) {
                List modes = filter.getMode();
                if (modes.contains(TMode.SYNC)) {
                    P callback = this.buildReaderSystem(filterId);
                    P consumer = this.buildReaderClient(filterId);
                    scope.add(callback);
                    scope.addExternal(consumer);
                    this.clientsPart.addProxyScope(filterId, null, callback);
                    this.externalPart.addProxyScope(filterId, null, consumer);
                }
                if (modes.contains(TMode.ASYNC)) {
                    P publisher = this.buildPublisher(filterId);
                    scope.add(publisher);
                    this.clientsPart.addProxyScope(filterId, null, publisher);
                }
            }
            this.scopes.add(scope);
            ++i;
        }
    }

    public abstract P buildPublisher(D2 var1) throws SystemException;

    public abstract P buildReaderSystem(D2 var1) throws SystemException;

    public abstract P buildReaderClient(D2 var1) throws SystemException;

    public abstract C buildListener(D2 var1) throws SystemException;

    public CallbackSystem<IO, D, D2, TSubscopeID, C> getListenersPart() {
        return this.listenersPart;
    }

    public ProxySystem<IO, D, P> getClientsPart() {
        return this.clientsPart;
    }

    public BrokerSystem<D> getBrokerPart() {
        return this.brokerPart;
    }

    public ProxySystem<IO, D, P> getExternalPart() {
        return this.externalPart;
    }
}

