/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe;

import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.dom4j.dom.DOMElement;
import org.ow2.choreos.xsa.xsb.platforms.apis.aspects.Logging;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.Callback;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.Contextual;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.PrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.data.ChoreosException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.exceptions.ChoreosInternalException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.primitives.MiddlewarePrimitive;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.primitives.SyncPrimitive;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSAsynchronousExchange;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSConnection;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSSynchronousExchange;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.EndListen;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.GetNext;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.Listen;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.Publish;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.Subscribe;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.Unsubscribe;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSystemID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.utils.CachedFilter;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.utils.CachedPSDLDefinition;

public abstract class PSPrimitiveFactory<IO, D extends CachedPSDLDefinition<?>, D1 extends TSystemID, D2 extends TScopeID, T1 extends PSSynchronousExchange<IO>, T2 extends PSAsynchronousExchange<IO>, C extends PSConnection>
extends PrimitiveFactory<IO, T1> {
    public Class publishClass;
    public Class subscribeClass;
    public Class listenClass;
    public Class endListenClass;
    public Class getNextClass;
    public Class unsubscribeClass;

    public PSPrimitiveFactory(int idPlatform) {
        super(idPlatform);
    }

    public void init() {
        super.init();
        this.primitivesPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new PSPoolablePrimitiveFactory());
    }

    public Publish<IO, D, D1, D2, T1> createPublish(String exchangeId, D definition, CachedFilter filter, DOMElement event, int lease) throws ChoreosInternalException {
        try {
            try {
                Publish publish = (Publish)this.primitivesPool.borrowObject((Object)this.publishClass);
                publish.init(exchangeId, this.idPlatform, definition, filter, event, lease);
                return publish;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public Publish<IO, D, D1, D2, T1>[] createPublish(String exchangeId, D definition, CachedFilter filter, DOMElement[] event, int lease) throws ChoreosInternalException {
        try {
            Publish[] result = new Publish[event.length];
            try {
                PSSynchronousExchange invocation = (PSSynchronousExchange)((Object)this.exchangePool.borrowObject());
                for (int i = 0; i < event.length; ++i) {
                    result[i] = this.createPublish(exchangeId, definition, filter, event[i], lease);
                    result[i].setInvocation(invocation);
                    result[i].setSetupPhase(false);
                    result[i].setAfterProcessPhase(false);
                }
                result[0].setSetupPhase(true);
                result[event.length - 1].setAfterProcessPhase(true);
                return result;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public Subscribe<IO, D, D1, D2, C> createSubscribe(String exchangeId, String handle, D definition, CachedFilter filter) throws ChoreosInternalException {
        try {
            try {
                Subscribe subscribe = (Subscribe)((Object)this.primitivesPool.borrowObject((Object)this.subscribeClass));
                subscribe.init(exchangeId, this.idPlatform, handle, definition, filter);
                return subscribe;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public Listen<IO, D, D1, D2, T2> createListen(String exchangeId, Callback callback, String handle) throws ChoreosInternalException {
        try {
            try {
                Listen listen = (Listen)this.primitivesPool.borrowObject((Object)this.listenClass);
                listen.init(exchangeId, this.idPlatform, callback, handle);
                return listen;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public EndListen createEndListen(String exchangeId, String handle) throws ChoreosInternalException {
        try {
            try {
                EndListen endListen = (EndListen)((Object)this.primitivesPool.borrowObject((Object)this.endListenClass));
                endListen.init(exchangeId, this.idPlatform, handle);
                return endListen;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public GetNext<IO, D, T1> createGetNext(String exchangeId, D definition, String handle, int timeout) throws ChoreosInternalException {
        try {
            try {
                GetNext getNext = (GetNext)this.primitivesPool.borrowObject((Object)this.getNextClass);
                getNext.init(exchangeId, this.idPlatform, definition, handle, timeout);
                PSSynchronousExchange invocation = (PSSynchronousExchange)((Object)this.exchangePool.borrowObject());
                getNext.setInvocation(invocation);
                getNext.setSetupPhase(true);
                getNext.setAfterProcessPhase(true);
                return getNext;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public Unsubscribe createUnsubscribe(String exchangeId, String handle) throws ChoreosInternalException {
        try {
            try {
                Unsubscribe unsubscribe = (Unsubscribe)((Object)this.primitivesPool.borrowObject((Object)this.unsubscribeClass));
                unsubscribe.init(exchangeId, this.idPlatform, handle);
                return unsubscribe;
            }
            catch (Exception e) {
                throw new ChoreosInternalException((Throwable)e);
            }
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public abstract Publish<IO, D, D1, D2, T1> buildPublish();

    public Subscribe<IO, D, D1, D2, C> buildSubscribe() {
        return new Subscribe();
    }

    public Listen<IO, D, D1, D2, T2> buildListen() {
        return new Listen();
    }

    public EndListen buildEndListen() {
        return new EndListen();
    }

    public abstract GetNext<IO, D, T1> buildGetNext();

    public Unsubscribe buildUnsubscribe() {
        return new Unsubscribe();
    }

    protected class PSPoolablePrimitiveFactory
    extends BaseKeyedPoolableObjectFactory<Class, MiddlewarePrimitive> {
        protected PSPoolablePrimitiveFactory() {
        }

        public MiddlewarePrimitive makeObject(Class key) throws Exception {
            if (key == PSPrimitiveFactory.this.publishClass) {
                return PSPrimitiveFactory.this.buildPublish();
            }
            if (key == PSPrimitiveFactory.this.subscribeClass) {
                return PSPrimitiveFactory.this.buildSubscribe();
            }
            if (key == PSPrimitiveFactory.this.listenClass) {
                return PSPrimitiveFactory.this.buildListen();
            }
            if (key == PSPrimitiveFactory.this.endListenClass) {
                return PSPrimitiveFactory.this.buildEndListen();
            }
            if (key == PSPrimitiveFactory.this.getNextClass) {
                return PSPrimitiveFactory.this.buildGetNext();
            }
            if (key == PSPrimitiveFactory.this.unsubscribeClass) {
                return PSPrimitiveFactory.this.buildUnsubscribe();
            }
            return null;
        }

        public void passivate(Class key, MiddlewarePrimitive primitive) throws Exception {
            primitive.uninit();
            if (primitive instanceof SyncPrimitive) {
                PSSynchronousExchange invocation = (PSSynchronousExchange)((SyncPrimitive)primitive).getInvocation();
                PSPrimitiveFactory.this.exchangePool.returnObject((Object)invocation);
            }
        }
    }
}

