/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives;

import org.ow2.choreos.xsa.xsb.platforms.apis.aspects.Logging;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.Contextual;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.data.ChoreosException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.data.PrimitiveException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.exceptions.ChoreosInternalException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.primitives.SetHandlePrimitive;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.PSPlatform;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSAsynchronousConnection;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSAsynchronousConnectionManager;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSConnection;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSSynchronousConnection;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.connections.PSSynchronousConnectionManager;
import org.ow2.choreos.xsa.xsb.platforms.apis.publishSubscribe.primitives.PSAsynchronousPrimitive;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSystemID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.utils.CachedFilter;
import org.ow2.choreos.xsa.xsb.specifications.parsers.psdl.utils.CachedPSDLDefinition;

public class Subscribe<IO, D extends CachedPSDLDefinition<?>, D1 extends TSystemID, D2 extends TScopeID, C extends PSConnection>
extends SetHandlePrimitive<D> {
    protected D1 broker;
    protected D2 filter;
    protected CachedFilter targetFilter;
    protected PSSynchronousConnection<D, D2, PSConnection> synchronousConnection;
    protected PSAsynchronousConnection<PSAsynchronousPrimitive, C> asynchronousConnection;
    protected PSSynchronousConnectionManager<D, PSConnection, PSSynchronousConnection<D, D2, PSConnection>> synchronousManager;
    protected PSAsynchronousConnectionManager<D, D2, C, PSAsynchronousConnection<PSAsynchronousPrimitive, C>> asynchronousManager;

    public void init(String exchangeId, int idPlatform, String handle, D definition, CachedFilter filter) {
        super.init(exchangeId, idPlatform, handle, definition);
        this.broker = definition.getId();
        this.filter = filter.getFilterId();
        this.autoEnd = true;
    }

    public void uninit() {
        super.uninit();
        this.broker = null;
        this.filter = null;
    }

    public void setUp() throws ChoreosException {
        try {
            this.targetFilter = ((CachedPSDLDefinition)this.definition).getFilter(this.filter);
            if (this.targetFilter.isSync()) {
                this.synchronousManager = PSSynchronousConnectionManager.getPSInstance(this.idPlatform);
                this.synchronousConnection = (PSSynchronousConnection)this.synchronousManager.getSynchronousConnection((TSystemID)this.broker);
                if (this.synchronousConnection == null) {
                    throw new ChoreosInternalException("No synchronous connection found for the id " + this.broker.getId());
                }
            }
            if (this.targetFilter.isAsync()) {
                this.asynchronousManager = PSAsynchronousConnectionManager.getPSInstance(this.idPlatform);
                this.asynchronousConnection = (PSAsynchronousConnection)this.asynchronousManager.getAsynchronousConnection((TSystemID)this.broker);
                if (this.asynchronousConnection == null) {
                    throw new ChoreosInternalException("No asynchronous connection found for the id " + this.broker.getId());
                }
            }
            return;
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    public void process() throws PrimitiveException {
        try {
            PSPlatform.getPSInstance(this.idPlatform).getHandledFilters().put(this.handle, this.targetFilter);
            if (this.targetFilter.isSync()) {
                this.synchronousManager.register(this.handle, this.synchronousConnection);
            }
            if (this.targetFilter.isAsync()) {
                this.asynchronousManager.register(this.handle, this.asynchronousConnection);
            }
            this.performSubscribe();
            super.process();
            return;
        }
        catch (ChoreosException choreosException) {
            Logging.aspectOf().ajc$afterThrowing$org_ow2_choreos_xsa_xsb_platforms_apis_aspects_Logging$1$7335c5f4((Contextual)this, choreosException);
            throw choreosException;
        }
    }

    protected void performSubscribe() {
    }

    public String[] getIds() {
        return new String[]{"subscribe_" + this.handle};
    }

    public static String getId(String handle) {
        return "subscribe_" + handle;
    }

    public D1 getBroker() {
        return this.broker;
    }

    public void setBroker(D1 broker) {
        this.broker = broker;
    }

    public D2 getFilter() {
        return this.filter;
    }

    public void setFilter(D2 filter) {
        this.filter = filter;
    }
}

