/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.client.TSGeneric;

import java.util.ArrayList;
import java.util.List;
import org.ow2.choreos.xsa.xsb.client.TSGeneric.TSProxySystem;
import org.ow2.choreos.xsa.xsb.client.TSGeneric.TSScope;
import org.ow2.choreos.xsa.xsb.client.TSGeneric.TSemantic;
import org.ow2.choreos.xsa.xsb.clients.generic.CallbackSystem;
import org.ow2.choreos.xsa.xsb.clients.generic.ICallbackScope;
import org.ow2.choreos.xsa.xsb.clients.generic.IProxyScope;
import org.ow2.choreos.xsa.xsb.clients.generic.ProxyScope;
import org.ow2.choreos.xsa.xsb.clients.generic.System;
import org.ow2.choreos.xsa.xsb.clients.generic.exceptions.SystemException;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTSDLScopes;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTSScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTemplate;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTemplateSemantic;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;

public abstract class TSSystem<IO, D extends CachedTSDLDefinition<?>, D2 extends TScopeID, D3 extends TSubscopeID, C extends ICallbackScope, P extends IProxyScope>
extends System<IO, D, TSScope<C, P>> {
    protected ArrayList<TSScope<C, P>>[] templates;
    protected CallbackSystem<IO, D, D2, D3, C> listenersPart = this.buildListenersPart();
    protected TSProxySystem<IO, D, D2, D3, P> clientsPart = this.buildProxyPart();
    protected TSProxySystem<IO, D, D2, D3, P> externalPart = this.buildExternalPart();

    public TSSystem(D definition) throws SystemException {
        super(definition);
        this.buildScopes(definition);
    }

    public void buildScopes(D definition) throws SystemException {
        TTSDLScopes s = (TTSDLScopes)((TSDLDefinition)definition.getDefinition()).getScopes().getValue();
        List scopes = s.getScope();
        this.templates = new ArrayList[scopes.size() + 1];
        this.templates[0] = new ArrayList();
        for (TTemplate template : s.getTemplate()) {
            this.processTemplate(0, null, template);
        }
        int i = 1;
        for (TTSScope scope : scopes) {
            this.templates[i] = new ArrayList();
            for (TTSScope.Subscope template : scope.getSubscope()) {
                TTemplate currentTemplate = (TTemplate)template.getTemplateRef();
                TScopeID scopeId = (TScopeID)scope.getScopeId().getValue();
                this.processTemplate(i, scopeId, currentTemplate);
            }
            ++i;
        }
    }

    protected void processTemplate(int scopeIndex, D2 scopeId, TTemplate template) throws SystemException {
        List semantic = template.getSemantic();
        List policies = template.getPolicy();
        TSubscopeID templateId = (TSubscopeID)template.getSubscopeId().getValue();
        TSScope scope = new TSScope(templateId.getId(), this);
        boolean writer = false;
        if (semantic.contains(TTemplateSemantic.OUT)) {
            C callback = this.buildCallback(scopeId, templateId);
            scope.add((Object)callback);
            this.listenersPart.addCallback(scopeId, templateId, callback);
        }
        if (semantic.contains(TTemplateSemantic.READ)) {
            if (policies.contains(TPolicy.COPY)) {
                P read = this.buildReader(scopeId, templateId);
                scope.add(read, TSemantic.READ);
                this.externalPart.addProxyScope((TScopeID)scopeId, templateId, (IProxyScope)read);
            }
            if (policies.contains(TPolicy.COPY_ALL)) {
                P readAll = this.buildReaderAll(scopeId, templateId);
                scope.add(readAll, TSemantic.READ_ALL);
                this.externalPart.addProxyAllScope((TScopeID)scopeId, templateId, (ProxyScope<ArrayList<IO>, D, D2, D3>)((ProxyScope)readAll));
            }
            writer = true;
        }
        if (semantic.contains(TTemplateSemantic.TAKE)) {
            if (policies.contains(TPolicy.REMOVE)) {
                P take = this.buildTaker(scopeId, templateId);
                scope.add(take, TSemantic.TAKE);
                this.externalPart.addProxyScope((TScopeID)scopeId, templateId, (IProxyScope)take);
            }
            if (policies.contains(TPolicy.REMOVE_ALL)) {
                P takeAll = this.buildTakerAll(scopeId, templateId);
                scope.add(takeAll, TSemantic.TAKE_ALL);
                this.externalPart.addProxyAllScope((TScopeID)scopeId, templateId, (ProxyScope<ArrayList<IO>, D, D2, D3>)((ProxyScope)takeAll));
            }
            writer = true;
        }
        if (writer) {
            P writerResource = this.buildWriter(scopeId, templateId);
            scope.add(writerResource);
            this.clientsPart.addProxyScope((TScopeID)scopeId, templateId, (IProxyScope)writerResource);
        }
        String id = this.buildId((TScopeID)scopeId, templateId);
        this.scopes.add(scope);
        this.templates[scopeIndex].add(scope);
    }

    protected abstract CallbackSystem<IO, D, D2, D3, C> buildListenersPart() throws SystemException;

    protected abstract TSProxySystem<IO, D, D2, D3, P> buildProxyPart() throws SystemException;

    protected abstract TSProxySystem<IO, D, D2, D3, P> buildExternalPart() throws SystemException;

    protected abstract C buildCallback(D2 var1, D3 var2) throws SystemException;

    protected abstract P buildReader(D2 var1, D3 var2) throws SystemException;

    protected abstract P buildTaker(D2 var1, D3 var2) throws SystemException;

    protected abstract P buildReaderAll(D2 var1, D3 var2) throws SystemException;

    protected abstract P buildTakerAll(D2 var1, D3 var2) throws SystemException;

    protected abstract P buildWriter(D2 var1, D3 var2) throws SystemException;

    public CallbackSystem<IO, D, D2, D3, C> getListenersPart() {
        return this.listenersPart;
    }

    public TSProxySystem<IO, D, D2, D3, P> getClientsPart() {
        return this.clientsPart;
    }

    public TSProxySystem<IO, D, D2, D3, P> getExternalPart() {
        return this.externalPart;
    }

    public ArrayList<TSScope<C, P>>[] getTemplates() {
        return this.templates;
    }
}

