/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import java.io.IOException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.DefinitionMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TArgument;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;
import org.xml.sax.SAXException;

public class TSDLDefinitionMocker<D extends CachedTSDLDefinition<?>>
extends DefinitionMocker<D> {
    public TSDLDefinitionMocker(Class<D> definitionClazz, String name) throws SAXException, IOException {
        super(definitionClazz, name);
    }

    public TSDLDefinitionMocker(Class<D> definitionClazz) {
        super(definitionClazz);
    }

    public Object addScope(InvocationMocker invocation, boolean outgoing, boolean incoming, boolean sync, boolean async) throws SAXException, IOException {
        super.addScope(invocation, outgoing, incoming, sync, async);
        boolean input = invocation.getInputdata() != null;
        boolean output = invocation.getOutputData() != null;
        CachedTemplate template = this.mockIOTemplate(invocation, input, output);
        if (incoming) {
            Mockito.when((Object)template.isIncoming()).thenReturn((Object)true);
            if (sync) {
                Mockito.when((Object)template.isSync()).thenReturn((Object)true);
            }
            if (async) {
                Mockito.when((Object)template.isAsync()).thenReturn((Object)true);
            }
        }
        if (outgoing) {
            Mockito.when((Object)template.isOutgoing()).thenReturn((Object)true);
            Mockito.when((Object)template.isSync()).thenReturn((Object)true);
        }
        return template;
    }

    protected CachedTemplate mockIOTemplate(InvocationMocker invocation, boolean input, boolean output) {
        CachedTemplate template = (CachedTemplate)Mockito.mock(CachedTemplate.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        TArgument tuple = null;
        if (input) {
            tuple = invocation.getInputdata().getDataType();
        }
        if (output) {
            tuple = invocation.getOutputData().getDataType();
        }
        Mockito.when((Object)template.getTemplate().getTuple()).thenReturn((Object)tuple);
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID templateId = invocation.getTarget().getSubscopeId();
        Mockito.when((Object)template.getTemplateId()).thenReturn((Object)templateId);
        if (scopeId != null) {
            CachedScope scope = (CachedScope)Mockito.mock(CachedScope.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)scope.getScopeId()).thenReturn((Object)scopeId);
            Mockito.when((Object)scope.getTemplate(templateId)).thenReturn((Object)template);
            Mockito.when((Object)((CachedTSDLDefinition)this.definition).getScope(scopeId)).thenReturn((Object)scope);
            Mockito.when((Object)((CachedTSDLDefinition)this.definition).getTemplate(scopeId, templateId)).thenReturn((Object)template);
        } else {
            Mockito.when((Object)((CachedTSDLDefinition)this.definition).getTemplate(templateId)).thenReturn((Object)template);
        }
        return template;
    }

    public void removeScope(InvocationMocker invocation) {
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID templateId = invocation.getTarget().getSubscopeId();
        if (scopeId != null) {
            Mockito.when((Object)((CachedTSDLDefinition)this.definition).getScope(scopeId)).thenReturn(null);
        }
        Mockito.when((Object)((CachedTSDLDefinition)this.definition).getTemplate(templateId)).thenReturn(null);
        Mockito.when((Object)((CachedTSDLDefinition)this.definition).getTemplate(scopeId, templateId)).thenReturn(null);
    }
}

