/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import javax.xml.transform.TransformerFactoryConfigurationError;
import org.hamcrest.AllOf;
import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsSame;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.esb.ChoreosServiceUnit;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.synchronization.Status;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PlatformMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PrimitiveFactoryMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Out;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;
import org.powermock.api.mockito.PowerMockito;

public class TestTSOut
extends TSChoreosTest {
    protected PlatformMocker platformMocker;
    protected PrimitiveFactoryMocker primitiveFactoryMocker;
    protected UnitMocker unitMocker;
    protected String exchangeId = "exchange1";
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSOut.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSOut.buildLogger(TestTSOut.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.platformMocker = this.buildPlatformMocker(true, false, true);
        this.primitiveFactoryMocker = this.platformMocker.getEsbCommMocker().getInterpreterMocker().getPrimitiveFactoryMocker();
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
    }

    @Test
    public void testOut() throws TransformerFactoryConfigurationError, Exception {
        this.mockOut(this.primitiveFactoryMocker, 1);
        this.platformMocker.setUnit(this.unitMocker);
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        TSPrimitiveFactory tsFactory = (TSPrimitiveFactory)this.primitiveFactoryMocker.getFactory();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setInput(new String[]{"tuple1"});
        invocation.setExchangeId(this.exchangeId);
        CachedTemplate template = (CachedTemplate)this.unitMocker.addSynchronousScope(invocation);
        CachedTSDLDefinition def = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = def.getScope(invocation.getTarget().getScopeId());
        this.platformMocker.setSynchronousScope(this.unitMocker, invocation, this.stringTuplespaceId);
        ChoreosTest.logger.info("Start the out test");
        this.platformMocker.getPlatform().deploySystem(unit);
        Out[] out = tsFactory.createOut(this.exchangeId, def, scope, template, invocation.getInputdata().getDomData(), -1);
        out[0].execute();
        out[0].getEndPrimitive().waitOn();
        PowerMockito.verifyPrivate((Object)out[0]).invoke("performOut", new Object[]{Mockito.argThat((Matcher)AllOf.allOf((Matcher)HasPropertyWithValue.hasProperty((String)"input", (Matcher)IsEqual.equalTo((Object)"tuple1")), (Matcher)HasPropertyWithValue.hasProperty((String)"inputType", (Matcher)IsSame.sameInstance((Object)invocation.getInputdata().getDataType()))))});
        this.platformMocker.getPlatform().undeploySystem(unit);
        DiagnosingMatcherAssert.assertThat((Object)out[0], (Matcher)HasPropertyWithValue.hasProperty((String)"status", (Matcher)IsEqual.equalTo((Object)Status.DONE)));
    }
}

