/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import javax.xml.transform.TransformerFactoryConfigurationError;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.GAFuture;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.esb.ChoreosServiceUnit;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.DataMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.GAMessageHelper;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InterpreterMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PlatformMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.connections.SynchronousInteraction;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Out;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSPrimitiveMatchers;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TPost;
import org.powermock.api.mockito.PowerMockito;

public class TestTSOutScenario
extends TSChoreosTest {
    protected PlatformMocker platformMocker;
    protected InterpreterMocker interpreterMocker;
    protected UnitMocker unitMocker;
    protected String exchangeId = "exchange1";
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSOutScenario.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSOutScenario.buildLogger(TestTSOutScenario.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.platformMocker = this.buildPlatformMocker(true, false, false);
        this.interpreterMocker = this.platformMocker.getEsbCommMocker().getInterpreterMocker();
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
    }

    @Test
    public void testPublishScenario() throws TransformerFactoryConfigurationError, Exception {
        Out[] outs = this.mockOut(this.interpreterMocker.getPrimitiveFactoryMocker(), 1);
        this.platformMocker.setUnit(this.unitMocker);
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.setInput(new String[]{"event1"});
        invocation.setExchangeId(this.exchangeId);
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        this.unitMocker.addSynchronousScope(invocation);
        this.platformMocker.setSynchronousScope(this.unitMocker, invocation, "tuplespace1");
        ChoreosTest.logger.info("Start the out scenario");
        this.platformMocker.getPlatform().deploySystem(unit);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)0);
        GAFuture futur = this.interpreterMocker.getInterpreter().interpret(post, this.exchangeId);
        futur.getEndInterpret().waitOn();
        Assert.assertNull((Object)futur.getResponseSync());
        PowerMockito.verifyPrivate((Object)outs[0]).invoke("performOut", new Object[]{Mockito.argThat((Matcher)TSPrimitiveMatchers.inputExchange((DataMocker)invocation.getInputdata(), (int)0))});
        this.platformMocker.getPlatform().undeploySystem(unit);
    }

    @Test
    public void testMultipleOutScenario() throws TransformerFactoryConfigurationError, Exception {
        Out[] outs = this.mockOut(this.interpreterMocker.getPrimitiveFactoryMocker(), 3);
        this.platformMocker.setUnit(this.unitMocker);
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.setInput(new String[]{"tuple1", "tuple2", "tuple3"});
        invocation.setExchangeId(this.exchangeId);
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        this.unitMocker.addSynchronousScope(invocation);
        this.platformMocker.setSynchronousScope(this.unitMocker, invocation, "tuplespace1");
        this.platformMocker.getPlatform().deploySystem(unit);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)0);
        GAFuture futur = this.interpreterMocker.getInterpreter().interpret(post, this.exchangeId);
        futur.getEndInterpret().waitOn();
        Assert.assertNull((Object)futur.getResponseSync());
        int i = 0;
        while (i < 3) {
            PowerMockito.verifyPrivate((Object)outs[i]).invoke("performOut", new Object[]{Mockito.any(SynchronousInteraction.class)});
            ++i;
        }
        this.platformMocker.getPlatform().undeploySystem(unit);
    }
}

