/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import java.lang.reflect.InvocationTargetException;
import org.hamcrest.DiagnosingMatcherAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.Callback;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.exceptions.ChoreosInternalException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.primitives.MiddlewarePrimitive;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PrimitiveFactoryMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ScopeMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Out;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Read;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.ReadAll;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Register;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Take;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.TakeAll;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Unregister;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSDLDefinitionMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSPrimitiveMatchers;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;

public class TestTSPrimitiveFactory
extends TSChoreosTest {
    protected PrimitiveFactoryMocker factoryMocker;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSPrimitiveFactory.configureChoreosTest();
        TestTSPrimitiveFactory.buildLogger(TestTSPrimitiveFactory.class, TSSystemFactory.class);
    }

    @Before
    public void setUp() throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.factoryMocker = this.buildPrimitiveFactoryMocker();
    }

    @Test
    public void testCreateOut() throws Exception {
        this.mockOut(this.factoryMocker, 1);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "tuplespace1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setInput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, true, false, true, false);
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        Out out = factory.createOut(exchangeId, definition, scope, template, invocation.getInputdata().getDomData()[0], -1);
        DiagnosingMatcherAssert.assertThat((Object)out, TSPrimitiveMatchers.out(exchangeId, invocation, 0, -1));
        factory.release((MiddlewarePrimitive)out);
    }

    @Test
    public void testCreateOut2() throws Exception {
        this.mockOut(this.factoryMocker, 1);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "tuplespace1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds(null, "template1");
        invocation.setInput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, true, false, true, false);
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(subscopeId);
        Out out = factory.createOut(exchangeId, definition, scope, template, invocation.getInputdata().getDomData()[0], -1);
        DiagnosingMatcherAssert.assertThat((Object)out, TSPrimitiveMatchers.out(exchangeId, invocation, 0, -1));
        factory.release((MiddlewarePrimitive)out);
    }

    @Test
    public void testCreateMultipleOut() throws Exception {
        Out[] outs = this.mockOut(this.factoryMocker, 3);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "tuplespace1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setInput(new String[]{"tuple1", "tuple2", "tuple3"});
        definitionMocker.addScope(invocation, true, false, true, false);
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        Out[] out = factory.createOut(exchangeId, definition, scope, template, invocation.getInputdata().getDomData(), -1);
        int i = 0;
        while (i < outs.length) {
            DiagnosingMatcherAssert.assertThat((Object)out[i], TSPrimitiveMatchers.out(exchangeId, invocation, i, -1));
            factory.release((MiddlewarePrimitive)out[i]);
            ++i;
        }
    }

    @Test
    public void testCreateMultipleOut2() throws Exception {
        Out[] outs = this.mockOut(this.factoryMocker, 3);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "tuplespace1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds(null, "template1");
        invocation.setInput(new String[]{"tuple1", "tuple2", "tuple3"});
        definitionMocker.addScope(invocation, true, false, true, false);
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(subscopeId);
        Out[] out = factory.createOut(exchangeId, definition, scope, template, invocation.getInputdata().getDomData(), -1);
        int i = 0;
        while (i < outs.length) {
            DiagnosingMatcherAssert.assertThat((Object)out[i], TSPrimitiveMatchers.out(exchangeId, invocation, i, -1));
            factory.release((MiddlewarePrimitive)out[i]);
            ++i;
        }
    }

    @Test
    public void testCreateTake() throws Exception {
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "system1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setOutput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, false, true, true, false);
        this.mockTake(this.factoryMocker, 1, invocation);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        Take take = factory.createTake(exchangeId, definition, scope, template, -1);
        DiagnosingMatcherAssert.assertThat((Object)take, TSPrimitiveMatchers.take(exchangeId, invocation.getTarget(), -1));
    }

    @Test
    public void testCreateTakeAll() throws Exception {
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "system1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setOutput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, false, true, true, false);
        this.mockTakeAll(this.factoryMocker, 1, invocation);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        TakeAll takeAll = factory.createTakeAll(exchangeId, definition, scope, template, -1);
        DiagnosingMatcherAssert.assertThat((Object)takeAll, TSPrimitiveMatchers.takeAll(exchangeId, invocation.getTarget(), -1));
    }

    @Test
    public void testCreateRead() throws Exception {
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "system1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setOutput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, false, true, true, false);
        this.mockRead(this.factoryMocker, 1, invocation);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        Read read = factory.createRead(exchangeId, definition, scope, template, -1);
        DiagnosingMatcherAssert.assertThat((Object)read, TSPrimitiveMatchers.read(exchangeId, invocation.getTarget(), -1));
    }

    @Test
    public void testCreateReadAll() throws Exception {
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "system1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setOutput(new String[]{"tuple1"});
        definitionMocker.addScope(invocation, false, true, true, false);
        this.mockReadAll(this.factoryMocker, 1, invocation);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.init();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        ReadAll readAll = factory.createReadAll(exchangeId, definition, scope, template, -1);
        DiagnosingMatcherAssert.assertThat((Object)readAll, TSPrimitiveMatchers.readAll(exchangeId, invocation.getTarget(), -1));
    }

    @Test
    public void testCreateRegister() throws Exception {
        String exchangeId = "exchange1";
        TSDLDefinitionMocker<CachedTSDLDefinition> definitionMocker = new TSDLDefinitionMocker<CachedTSDLDefinition>(CachedTSDLDefinition.class, "system1");
        CachedTSDLDefinition definition = (CachedTSDLDefinition)definitionMocker.getDefinition();
        InvocationMocker invocation = definitionMocker.generateInvocationMocker();
        invocation.getTarget().mockScopeIds("scope1", "template1");
        invocation.setOutput(new String[]{"tuple1"});
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main1", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        definitionMocker.addScope(invocation, false, true, true, true);
        this.mockRead(this.factoryMocker, 1, invocation);
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.registerClass = Register.class;
        factory.init();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        Register register = factory.createRegister(exchangeId, definition, callback, scope, template, "handle1", TPolicy.COPY);
        DiagnosingMatcherAssert.assertThat((Object)register, TSPrimitiveMatchers.register(exchangeId, invocation, "handle1", callback, TPolicy.COPY));
    }

    @Test
    public void testCreateUnregister() throws ChoreosInternalException {
        String exchangeId = "exchange1";
        String handle = "handle1";
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.factoryMocker.mockFactory();
        factory.unregisterClass = Unregister.class;
        factory.init();
        Unregister unregister = factory.createUnregister(exchangeId, handle);
        DiagnosingMatcherAssert.assertThat((Object)unregister, TSPrimitiveMatchers.unregister(exchangeId, handle));
    }
}

