/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContainingInOrder;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.stubbing.Answer;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.gaPrimitives.tests.GAMessageMatchers;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.Callback;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.GAFuture;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.PrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.ThreadScheduling;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.exceptions.NotAllowedPrimitiveException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.exceptions.UnknownIdException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.primitives.MiddlewarePrimitive;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.synchronization.Synchronizer;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.synchronization.ValuedSynchronizer;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.GAMessageHelper;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InterpreterMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ScopeMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPlatform;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveInterpreter;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Read;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Register;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Unregister;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSPrimitiveMatchers;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TScopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TSubscopeID;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetAsync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TPost;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGetResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTemplateSemantic;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;
import org.ow2.choreos.xsa.xsb.utils.HasAttributeWithValue;
import org.ow2.choreos.xsa.xsb.utils.mocks.HyperPowerMockito;

public class TestTSPrimitiveInterpreter
extends TSChoreosTest {
    protected InterpreterMocker<CachedTSDLDefinition<?>> interpreterMocker;
    protected TSPrimitiveInterpreter interpreter;
    protected TSPlatform platform;
    protected UnitMocker unitMocker;
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSPrimitiveInterpreter.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSPrimitiveInterpreter.buildLogger(TestTSPrimitiveInterpreter.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.interpreterMocker = this.buildInterpreterMocker(true);
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
        this.platform = (TSPlatform)HyperPowerMockito.mock(TSPlatform.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testInterpretPost() throws Exception {
        this.mockOut(this.interpreterMocker.getPrimitiveFactoryMocker(), 1);
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setInput(new String[]{"tuple1"});
        this.unitMocker.getDefinitionMocker().addScope(invocation, true, false, true, false);
        this.interpreter.addDefinition(this.unitMocker.getSystem(), this.platform.getESBCommManager());
        this.interpreterMocker.mockSystemId(invocation);
        this.interpreterMocker.mockScopeIds(invocation);
        this.interpreterMocker.mockTransformation(invocation);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)-1);
        this.interpreter.interpret(post, "exchange1");
        Matcher matcher = IsArrayContainingInOrder.arrayContaining((Matcher[])new Matcher[]{TSPrimitiveMatchers.out("exchange1", invocation, 0, -1)});
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive[])Matchers.argThat((Matcher)matcher), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.SINGLE), (String)Mockito.isNull(String.class));
    }

    @Test(expected=NotAllowedPrimitiveException.class)
    public void testInterpretretNotAlloawedPost() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setInput(new String[]{"tuple1"});
        this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, false, true);
        this.interpreter.addDefinition(this.unitMocker.getSystem(), this.platform.getESBCommManager());
        this.interpreterMocker.mockSystemId(invocation);
        this.interpreterMocker.mockScopeIds(invocation);
        this.interpreterMocker.mockTransformation(invocation);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)-1);
        this.interpreter.interpret(post, "exchange1");
    }

    @Test(expected=UnknownIdException.class)
    public void testBadSystemIdPost() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setInput(new String[]{"tuple1"});
        this.interpreterMocker.mockSystemId(invocation);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)-1);
        this.interpreter.interpret(post, "exchange1");
    }

    @Test(expected=UnknownIdException.class)
    public void testBadTemplateIdPost() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setInput(new String[]{"tuple1"});
        this.unitMocker.getDefinitionMocker().addScope(invocation, true, false, true, false);
        this.unitMocker.getDefinitionMocker().removeScope(invocation);
        this.interpreter.addDefinition(this.unitMocker.getSystem(), this.platform.getESBCommManager());
        this.interpreterMocker.mockSystemId(invocation);
        this.interpreterMocker.mockScopeIds(invocation);
        TPost post = GAMessageHelper.createPost((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (int)0);
        this.interpreter.interpret(post, "exchange1");
    }

    @Test
    public void testInterpretSetupGet() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        String exchangeId = "exchange1";
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setOutput(new String[]{"tuple1"});
        this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        TScopeID scopeId = invocation.getTarget().getScopeId();
        TSubscopeID subscopeId = invocation.getTarget().getSubscopeId();
        CachedScope scope = definition.getScope(scopeId);
        CachedTemplate template = definition.getTemplate(scopeId, subscopeId);
        this.interpreter.addDefinition(this.unitMocker.getSystem(), this.platform.getESBCommManager());
        this.interpreterMocker.mockSystemId(invocation);
        this.interpreterMocker.mockScopeIds(invocation);
        TSetupGet setupGet = GAMessageHelper.createSetupGet((TCoupling)TCoupling.VERY_WEAK, (ScopeMocker)invocation.getTarget(), (String)handle);
        GAFuture futur = this.interpreter.interpret(setupGet, exchangeId);
        TSetupGetResponse response = (TSetupGetResponse)futur.getResponseSync().waitOn("handle1");
        DiagnosingMatcherAssert.assertThat((Object)response, (Matcher)GAMessageMatchers.setupGetResponse((Matcher[])new Matcher[]{GAMessageMatchers.handle((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"handle1")})}));
        DiagnosingMatcherAssert.assertThat((Object)this.interpreter, (Matcher)HasAttributeWithValue.hasAttribute((String)"handledScopes", (Matcher)IsMapContaining.hasEntry((Matcher)IsEqual.equalTo((Object)"handle1"), (Matcher)IsSame.sameInstance((Object)scope))));
        DiagnosingMatcherAssert.assertThat((Object)this.interpreter, (Matcher)HasAttributeWithValue.hasAttribute((String)"handledTemplates", (Matcher)IsMapContaining.hasEntry((Matcher)IsEqual.equalTo((Object)"handle1"), (Matcher)IsSame.sameInstance((Object)template))));
    }

    @Test(expected=UnknownIdException.class)
    public void testInterpretSetupGetBadSystemId() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        String exchangeId = "exchange1";
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        this.unitMocker.addAsynchronousScope(invocation, TPolicy.COPY, handle);
        this.interpreterMocker.mockSystemId(invocation);
        TSetupGet setupGet = GAMessageHelper.createSetupGet((TCoupling)TCoupling.VERY_WEAK, (ScopeMocker)invocation.getTarget(), (String)handle);
        this.interpreter.interpret(setupGet, exchangeId);
    }

    @Test(expected=UnknownIdException.class)
    public void testInterpretSetupGetBadTemplateId() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        String exchangeId = "exchange1";
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        this.unitMocker.getDefinitionMocker().removeScope(invocation);
        this.interpreterMocker.mockSystemId(invocation);
        this.interpreterMocker.mockScopeIds(invocation);
        this.interpreter.addDefinition(this.unitMocker.getSystem(), this.platform.getESBCommManager());
        this.unitMocker.getDefinitionMocker().removeScope(invocation);
        TSetupGet setupGet = GAMessageHelper.createSetupGet((TCoupling)TCoupling.VERY_WEAK, (ScopeMocker)invocation.getTarget(), (String)handle);
        this.interpreter.interpret(setupGet, exchangeId);
    }

    @Test
    public void testInterpretGetSyncCopy() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setOutput(new String[]{"tuple1"});
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        Mockito.when((Object)template.isSync()).thenReturn((Object)true);
        Mockito.when((Object)template.getTemplate().getSemantic().contains(TTemplateSemantic.READ)).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        String exchange = "exchange1";
        String handle = "handle1";
        String cfr_ignored_0 = "subscribe_" + handle;
        this.mockRead(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        Read[] reads = new Read[]{(Read)HyperPowerMockito.mock(Read.class, (Answer)Mockito.CALLS_REAL_METHODS, (Class[])new Class[]{Synchronizer.class, ValuedSynchronizer.class})};
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getScopeId()).when((Object)reads[0])).getScope();
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getSubscopeId()).when((Object)reads[0])).getTemplate();
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.COPY, (String)handle, (int)-1);
        this.interpreter.interpret(getSync, exchange);
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.read(exchange, invocation.getTarget(), -1)), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.SINGLE), (String)Mockito.isNull(String.class));
    }

    @Test
    public void testInterpretGetSyncCopyAll() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setOutput(new String[]{"tuple1"});
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        Mockito.when((Object)template.isSync()).thenReturn((Object)true);
        Mockito.when((Object)template.getTemplate().getSemantic().contains(TTemplateSemantic.READ)).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        String exchange = "exchange1";
        String handle = "handle1";
        String cfr_ignored_0 = "subscribe_" + handle;
        this.mockReadAll(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        Read[] reads = new Read[]{(Read)HyperPowerMockito.mock(Read.class, (Answer)Mockito.CALLS_REAL_METHODS, (Class[])new Class[]{Synchronizer.class, ValuedSynchronizer.class})};
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getScopeId()).when((Object)reads[0])).getScope();
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getSubscopeId()).when((Object)reads[0])).getTemplate();
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.COPY_ALL, (String)handle, (int)-1);
        this.interpreter.interpret(getSync, exchange);
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.readAll(exchange, invocation.getTarget(), -1)), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.SINGLE), (String)Mockito.isNull(String.class));
    }

    @Test
    public void testInterpretGetSyncRemove() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setOutput(new String[]{"tuple1"});
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        Mockito.when((Object)template.isSync()).thenReturn((Object)true);
        Mockito.when((Object)template.getTemplate().getSemantic().contains(TTemplateSemantic.TAKE)).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        String exchange = "exchange1";
        String handle = "handle1";
        String cfr_ignored_0 = "subscribe_" + handle;
        this.mockTake(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        Read[] reads = new Read[]{(Read)HyperPowerMockito.mock(Read.class, (Answer)Mockito.CALLS_REAL_METHODS, (Class[])new Class[]{Synchronizer.class, ValuedSynchronizer.class})};
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getScopeId()).when((Object)reads[0])).getScope();
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getSubscopeId()).when((Object)reads[0])).getTemplate();
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.REMOVE, (String)handle, (int)-1);
        this.interpreter.interpret(getSync, exchange);
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.take(exchange, invocation.getTarget(), -1)), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.SINGLE), (String)Mockito.isNull(String.class));
    }

    @Test
    public void testInterpretGetSyncRemoveAll() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setOutput(new String[]{"tuple1"});
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        Mockito.when((Object)template.isSync()).thenReturn((Object)true);
        Mockito.when((Object)template.getTemplate().getSemantic().contains(TTemplateSemantic.TAKE)).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        String exchange = "exchange1";
        String handle = "handle1";
        String cfr_ignored_0 = "subscribe_" + handle;
        this.mockTakeAll(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        Read[] reads = new Read[]{(Read)HyperPowerMockito.mock(Read.class, (Answer)Mockito.CALLS_REAL_METHODS, (Class[])new Class[]{Synchronizer.class, ValuedSynchronizer.class})};
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getScopeId()).when((Object)reads[0])).getScope();
        ((Read)Mockito.doReturn((Object)invocation.getTarget().getSubscopeId()).when((Object)reads[0])).getTemplate();
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.REMOVE_ALL, (String)handle, (int)-1);
        this.interpreter.interpret(getSync, exchange);
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.takeAll(exchange, invocation.getTarget(), -1)), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.SINGLE), (String)Mockito.isNull(String.class));
    }

    @Test(expected=UnknownIdException.class)
    public void testInterpretGetSyncBadHandle() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        this.platform = (TSPlatform)HyperPowerMockito.mock(TSPlatform.class, (Answer)Mockito.CALLS_REAL_METHODS);
        String handle = "handle1";
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.COPY, (String)handle, (int)-1);
        this.interpreter.interpret(getSync, "exchange1");
    }

    @Test
    public void testInterpretGetAsync() throws Exception {
        String exchangeId = "exchange1";
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, null);
        invocation.setOutput(new String[]{"tuple1"});
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        CachedTemplate template = (CachedTemplate)this.unitMocker.addAsynchronousScope(invocation, TPolicy.COPY, handle);
        Mockito.when((Object)template.isAsync()).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        this.mockRead(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        this.interpreterMocker.mockInterpreter();
        this.interpreterMocker.addNotificationPolicy("handle1", TPolicy.COPY);
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.interpreterMocker.getPrimitiveFactoryMocker().getFactory();
        factory.registerClass = Register.class;
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.interpreterMocker.getCallbacks().put("callback1", callback);
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TGetAsync getAsync = GAMessageHelper.createGetAsync((TCoupling)TCoupling.VERY_WEAK, (InvocationMocker)invocation, (String)handle);
        this.interpreter.interpret(getAsync, "exchange1");
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.register(exchangeId, invocation, handle, callback, TPolicy.COPY)), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.CREATE), (String)Mockito.eq((Object)handle));
    }

    @Test(expected=UnknownIdException.class)
    public void testInterpretGetAsyncBadHandle() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, null);
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        this.unitMocker.addAsynchronousScope(invocation, TPolicy.COPY, handle);
        this.platform = (TSPlatform)HyperPowerMockito.mock(TSPlatform.class, (Answer)Mockito.CALLS_REAL_METHODS);
        TGetAsync getAsync = GAMessageHelper.createGetAsync((TCoupling)TCoupling.WEAK, (InvocationMocker)invocation, (String)handle);
        this.interpreter.interpret(getAsync, "exchange1");
    }

    @Test
    public void testInterpretEndGetAsync() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        TSPrimitiveFactory factory = (TSPrimitiveFactory)this.interpreterMocker.getPrimitiveFactoryMocker().getFactory();
        factory.unregisterClass = Unregister.class;
        TEndGetAsync endGetAsync = GAMessageHelper.createEndGetAsync((String)"handle1");
        this.interpreter.interpret(endGetAsync, "exchange1");
        ((TSPlatform)Mockito.verify((Object)this.platform)).execute((MiddlewarePrimitive)Matchers.argThat(TSPrimitiveMatchers.unregister("exchange1", "handle1")), (PrimitiveFactory)Mockito.any(PrimitiveFactory.class), (ThreadScheduling)Mockito.eq((Object)ThreadScheduling.END), (String)Mockito.eq((Object)"handle1"));
    }

    @Test
    public void testInterpretEndGet() throws Exception {
        this.interpreterMocker.mockInterpreter();
        this.interpreter = (TSPrimitiveInterpreter)this.interpreterMocker.getInterpreter();
        String exchangeId = "exchange1";
        String handle = "handle1";
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, null);
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("main", "subscope1", "subsubscope1");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        CachedTemplate template = (CachedTemplate)this.unitMocker.addAsynchronousScope(invocation, TPolicy.COPY, handle);
        Mockito.when((Object)template.isAsync()).thenReturn((Object)true);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = definition.getScope(invocation.getTarget().getScopeId());
        Mockito.when((Object)this.platform.getHandledSystems()).thenCallRealMethod();
        this.platform.getHandledSystems().put(handle, this.unitMocker.getDefinitionMocker().getDefinition());
        HashMap<String, CachedScope> scopes = new HashMap<String, CachedScope>();
        scopes.put("handle1", scope);
        HashMap<String, CachedTemplate> templates = new HashMap<String, CachedTemplate>();
        templates.put("handle1", template);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledScopes", scopes);
        Whitebox.setInternalState((Object)this.interpreter, (String)"handledTemplates", templates);
        TEndGet endGet = GAMessageHelper.createEndGet((String)handle);
        this.interpreter.interpret(endGet, exchangeId);
        Map m1 = (Map)Whitebox.getInternalState((Object)this.interpreter, (String)"handledScopes");
        Map m2 = (Map)Whitebox.getInternalState((Object)this.interpreter, (String)"handledTemplates");
        DiagnosingMatcherAssert.assertThat(m1.get(handle), (Matcher)IsNull.nullValue());
        DiagnosingMatcherAssert.assertThat(m2.get(handle), (Matcher)IsNull.nullValue());
        DiagnosingMatcherAssert.assertThat(this.platform.getHandledSystems().get(handle), (Matcher)IsNull.nullValue());
    }
}

