/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.GAFuture;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.esb.ChoreosServiceUnit;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.DataMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.GAMessageHelper;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InterpreterMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PlatformMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PrimitiveFactoryMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ScopeMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveInterpreter;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TEndGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSync;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSyncResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGet;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TSetupGetResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.TTemplateSemantic;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;

public class TestTSReadAllScenario
extends TSChoreosTest {
    protected PlatformMocker platformMocker;
    protected InterpreterMocker interpreterMocker;
    protected TSPrimitiveInterpreter interpreter;
    protected UnitMocker unitMocker;
    protected String exchangeId = "exchange1";
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSReadAllScenario.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSReadAllScenario.buildLogger(TestTSReadAllScenario.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.platformMocker = this.buildPlatformMocker(true, false, true);
        this.interpreterMocker = this.platformMocker.getEsbCommMocker().getInterpreterMocker();
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
    }

    @Test
    public void testRead() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.setOutput(new String[]{"tuple1", "tuple2", "tuple3"});
        invocation.setExchangeId(this.exchangeId);
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        PrimitiveFactoryMocker factoryMocker = this.interpreterMocker.getPrimitiveFactoryMocker();
        this.mockReadAll(factoryMocker, 1, invocation);
        this.platformMocker.setUnit(this.unitMocker);
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        Mockito.when((Object)template.getTemplate().getSemantic().contains(TTemplateSemantic.READ)).thenReturn((Object)true);
        this.platformMocker.setSynchronousScope(this.unitMocker, invocation, "tuplespace1");
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        this.platformMocker.getPlatform().deploySystem(unit);
        TSetupGet setupGet = GAMessageHelper.createSetupGet((TCoupling)TCoupling.VERY_WEAK, (ScopeMocker)invocation.getTarget(), (String)"handle1");
        GAFuture futur = this.interpreterMocker.getInterpreter().interpret(setupGet, "exchange1");
        TSetupGetResponse cfr_ignored_0 = (TSetupGetResponse)futur.getResponseSync().waitOn("handle1");
        TGetSync getSync = GAMessageHelper.createGetSync((TCoupling)TCoupling.VERY_WEAK, (TPolicy)TPolicy.COPY_ALL, (String)"handle1", (int)-1);
        GAFuture futur2 = this.interpreterMocker.getInterpreter().interpret(getSync, "exchange2");
        TGetSyncResponse response = (TGetSyncResponse)futur2.getResponseSync().waitOn("handle1");
        TEndGet endGet = GAMessageHelper.createEndGet((String)"handle1");
        this.interpreterMocker.getInterpreter().interpret(endGet, "exchange3");
        futur2.getOwnerThread().join();
        this.platformMocker.getPlatform().undeploySystem(unit);
        DiagnosingMatcherAssert.assertThat((Object)response, (Matcher)GAMessageHelper.getSyncResponseMatcher((TCoupling)TCoupling.VERY_WEAK, (DataMocker)invocation.getOutputData(), (String)"handle1"));
    }
}

