/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.gaPrimitives.tests.GAMessageMatchers;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.data.Exchange;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.esb.ChoreosServiceUnit;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.synchronization.Synchronizer;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.DataMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.GAMessageHelper;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InterpreterMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PlatformMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PrimitiveFactoryMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ScopeMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveInterpreter;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Register;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Unregister;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.TPolicy;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.utils.CachedDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;

public class TestTSRegisterScenario
extends TSChoreosTest {
    protected PlatformMocker platformMocker;
    protected InterpreterMocker interpreterMocker;
    protected TSPrimitiveInterpreter interpreter;
    protected UnitMocker unitMocker;
    protected String exchangeId = "exchange1";
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSRegisterScenario.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSRegisterScenario.buildLogger(TestTSRegisterScenario.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.platformMocker = this.buildPlatformMocker(true, true, true);
        this.interpreterMocker = this.platformMocker.getEsbCommMocker().getInterpreterMocker();
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
    }

    @Test
    public void testRegister1() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.setOutput(new String[]{"tuple1"});
        invocation.getOutputData().mockToW3CDataConversion(false);
        invocation.setExchangeId(this.exchangeId);
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.mockCallback("callback1");
        ScopeMocker notificationTarget = new ScopeMocker("mainId", "subscopeId", "subsubscopeId");
        invocation.addOneWayNotification(notificationTarget, "target1", -1);
        this.mockRead(this.interpreterMocker.getPrimitiveFactoryMocker(), 1, invocation);
        PrimitiveFactoryMocker factoryMocker = this.interpreterMocker.getPrimitiveFactoryMocker();
        factoryMocker.mockFactory();
        this.unitMocker.addAsynchronousScope(invocation, TPolicy.COPY, "handle1");
        this.unitMocker.addSynchronousScope(invocation);
        CachedTSDLDefinition definition = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        this.platformMocker.setUnit(this.unitMocker);
        this.platformMocker.setAsynchronousScope(this.unitMocker, "handle1", invocation);
        String handleThread = invocation.getTarget().getSystemId().getId();
        String handleResources = this.exchangeId;
        this.platformMocker.getSynchronousConnectionManagerMocker().mockSynchronousConnectionManager((CachedDefinition)definition, handleThread, handleResources);
        TSPrimitiveFactory tsFactory = (TSPrimitiveFactory)factoryMocker.getFactory();
        tsFactory.registerClass = Register.class;
        tsFactory.unregisterClass = Unregister.class;
        Synchronizer sync1 = this.platformMocker.getEsbCommMocker().mockSendIn(GAMessageMatchers.asGAMessage((Matcher[])new Matcher[]{GAMessageMatchers.post((Matcher[])new Matcher[]{GAMessageMatchers.coupling((TCoupling)TCoupling.VERY_WEAK), GAMessageHelper.scope((ScopeMocker)notificationTarget), GAMessageHelper.data((DataMocker)invocation.getOutputData()), GAMessageMatchers.lease((Matcher[])new Matcher[]{GAMessageMatchers.leaseForever()})})}), "mainId", this.stringTuplespaceId);
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        this.platformMocker.getPlatform().deploySystem(unit);
        Exchange exchange1 = invocation.createIncomingExchange("handle1", 0);
        this.platformMocker.getAsynchronousConnectionManagerMocker().processNotification("handle1", exchange1);
        this.platformMocker.getPlatform().undeploySystem(unit);
        sync1.waitOn();
    }
}

