/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test;

import junit.framework.Assert;
import org.hamcrest.DiagnosingMatcherAssert;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.choreos.xsa.xsb.gaPrimitives.GAMessageFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.SystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.data.ChoreosException;
import org.ow2.choreos.xsa.xsb.platforms.apis.generic.esb.ChoreosServiceUnit;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.ChoreosTest;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.DataMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.GAMessageHelper;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.InvocationMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PlatformMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.PrimitiveFactoryMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tests.utils.UnitMocker;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPlatform;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSPrimitiveFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.TSSystemFactory;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.primitives.Take;
import org.ow2.choreos.xsa.xsb.platforms.apis.tupleSpaces.test.TSChoreosTest;
import org.ow2.choreos.xsa.xsb.specifications.parsers.dl.utils.CachedDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.ga.TCoupling;
import org.ow2.choreos.xsa.xsb.specifications.parsers.gaMessage.TGetSyncResponse;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedScope;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTSDLDefinition;
import org.ow2.choreos.xsa.xsb.specifications.parsers.tsdl.utils.CachedTemplate;

public class TestTSTake
extends TSChoreosTest {
    protected PlatformMocker platformMocker;
    protected PrimitiveFactoryMocker primitiveFactoryMocker;
    protected UnitMocker unitMocker;
    protected String exchangeId = "exchange1";
    protected String stringTuplespaceId = "tuplespace1";
    protected String stringScopeId = "scope1";
    protected String stringTemplateId = "template1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestTSTake.configureChoreosTest();
    }

    @Before
    public void setUp() throws Exception {
        TestTSTake.buildLogger(TestTSTake.class, TSSystemFactory.class);
        SystemFactory.gaMessageFactory = (GAMessageFactory)Mockito.spy((Object)new GAMessageFactory());
        this.platformMocker = this.buildPlatformMocker(true, false, true);
        this.primitiveFactoryMocker = this.platformMocker.getEsbCommMocker().getInterpreterMocker().getPrimitiveFactoryMocker();
        this.unitMocker = this.buildUnitMocker(this.stringTuplespaceId);
    }

    @Test
    public void testRead() throws Exception {
        InvocationMocker invocation = this.unitMocker.getDefinitionMocker().generateInvocationMocker();
        invocation.getTarget().mockScopeIds(this.stringScopeId, this.stringTemplateId);
        invocation.setExchangeId(this.exchangeId);
        invocation.setOutput(new String[]{"tuple1"});
        CachedTemplate template = (CachedTemplate)this.unitMocker.getDefinitionMocker().addScope(invocation, false, true, true, false);
        CachedTSDLDefinition def = (CachedTSDLDefinition)this.unitMocker.getDefinitionMocker().getDefinition();
        CachedScope scope = def.getScope(invocation.getTarget().getScopeId());
        this.platformMocker.setUnit(this.unitMocker);
        ChoreosServiceUnit unit = this.unitMocker.getUnit();
        this.platformMocker.setSynchronousScope(this.unitMocker, invocation, this.stringTuplespaceId);
        this.platformMocker.getConnectionManagerMocker().mockConnectionManager((CachedDefinition)def);
        this.mockTake(this.primitiveFactoryMocker, 1, invocation);
        this.primitiveFactoryMocker.mockFactory();
        TSPrimitiveFactory tsFactory = (TSPrimitiveFactory)this.primitiveFactoryMocker.getFactory();
        tsFactory.init();
        ChoreosTest.logger.info("Start the read test");
        TSPlatform platform = (TSPlatform)this.platformMocker.getPlatform();
        platform.deploySystem(unit);
        platform.getHandledSystems().put("handle1", def);
        final Take take = tsFactory.createTake(this.exchangeId, def, scope, template, -1);
        take.setHandle("handle1");
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    take.execute();
                }
                catch (ChoreosException choreosException) {
                    Assert.fail();
                }
            }
        });
        th.start();
        TGetSyncResponse response = (TGetSyncResponse)take.getResponseSynchronizer().waitOn("handle1");
        take.getEndPrimitive().waitOn();
        th.join();
        platform.undeploySystem(unit);
        DiagnosingMatcherAssert.assertThat((Object)response, (Matcher)GAMessageHelper.getSyncResponseMatcher((TCoupling)TCoupling.VERY_WEAK, (DataMocker)invocation.getOutputData(), (String)"handle1"));
    }
}

