/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.specifications.parsers.gadl.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import org.dom4j.Namespace;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    public static void trimEmptyTextNodes(Node node) {
        Element element = null;
        if (node instanceof Document) {
            element = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            element = (Element)node;
        } else {
            return;
        }
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Text t;
            Node child = children.item(i);
            if (child instanceof Element) {
                DOMUtils.trimEmptyTextNodes(child);
                continue;
            }
            if (!(child instanceof Text) || (t = (Text)child).getData().trim().length() != 0) continue;
            nodesToRemove.add(child);
        }
        for (Node n : nodesToRemove) {
            element.removeChild(n);
        }
    }

    public static void compareNodes(Node expected, Node actual, boolean trimEmptyTextNodes) throws Exception {
        if (trimEmptyTextNodes) {
            DOMUtils.trimEmptyTextNodes(expected);
            DOMUtils.trimEmptyTextNodes(actual);
        }
        DOMUtils.compareNodes(expected, actual);
    }

    public static void compareNodes(Node expected, Node actual) throws Exception {
        String actualData;
        String expectedData;
        if (expected.getNodeType() != actual.getNodeType()) {
            throw new Exception("Different types of nodes: " + expected + " " + actual);
        }
        if (expected instanceof Document) {
            Document expectedDoc = (Document)expected;
            Document actualDoc = (Document)actual;
            DOMUtils.compareNodes(expectedDoc.getDocumentElement(), actualDoc.getDocumentElement());
        } else if (expected instanceof Element) {
            Element expectedElement = (Element)expected;
            Element actualElement = (Element)actual;
            if (!expectedElement.getLocalName().equals(actualElement.getLocalName())) {
                throw new Exception("Element names do not match: " + expectedElement.getLocalName() + " " + actualElement.getLocalName());
            }
            String expectedNS = expectedElement.getNamespaceURI();
            String actualNS = actualElement.getNamespaceURI();
            if (expectedNS == null && actualNS != null || expectedNS != null && !expectedNS.equals(actualNS)) {
                throw new Exception("Element namespaces names do not match: " + expectedNS + " " + actualNS);
            }
            String elementName = "{" + expectedElement.getNamespaceURI() + "}" + actualElement.getLocalName();
            NamedNodeMap expectedAttrs = expectedElement.getAttributes();
            NamedNodeMap actualAttrs = actualElement.getAttributes();
            if (DOMUtils.countNonNamespaceAttribures(expectedAttrs) != DOMUtils.countNonNamespaceAttribures(actualAttrs)) {
                throw new Exception(elementName + ": Number of attributes do not match up: " + DOMUtils.countNonNamespaceAttribures(expectedAttrs) + " " + DOMUtils.countNonNamespaceAttribures(actualAttrs));
            }
            for (int i = 0; i < expectedAttrs.getLength(); ++i) {
                Attr expectedAttr = (Attr)expectedAttrs.item(i);
                if (expectedAttr.getName().startsWith("xmlns")) continue;
                Attr actualAttr = null;
                actualAttr = expectedAttr.getNamespaceURI() == null ? (Attr)actualAttrs.getNamedItem(expectedAttr.getName()) : (Attr)actualAttrs.getNamedItemNS(expectedAttr.getNamespaceURI(), expectedAttr.getLocalName());
                if (actualAttr == null) {
                    throw new Exception(elementName + ": No attribute found:" + expectedAttr);
                }
                if (expectedAttr.getValue().equals(actualAttr.getValue())) continue;
                throw new Exception(elementName + ": Attribute values do not match: " + expectedAttr.getValue() + " " + actualAttr.getValue());
            }
            NodeList expectedChildren = expectedElement.getChildNodes();
            NodeList actualChildren = actualElement.getChildNodes();
            if (expectedChildren.getLength() != actualChildren.getLength()) {
                throw new Exception(elementName + ": Number of children do not match up: " + expectedChildren.getLength() + " " + actualChildren.getLength());
            }
            for (int i = 0; i < expectedChildren.getLength(); ++i) {
                Node expectedChild = expectedChildren.item(i);
                Node actualChild = actualChildren.item(i);
                DOMUtils.compareNodes(expectedChild, actualChild);
            }
        } else if (expected instanceof Text && !(expectedData = ((Text)expected).getData().trim()).equals(actualData = ((Text)actual).getData().trim())) {
            throw new Exception("Text does not match: " + expectedData + " " + actualData);
        }
    }

    private static int countNonNamespaceAttribures(NamedNodeMap attrs) {
        int n = 0;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            ++n;
        }
        return n;
    }

    public static int generateHashCode(Node node) {
        if (node instanceof Element) {
            Element nodeElt = (Element)node;
            String namespace = nodeElt.getNamespaceURI();
            String name = nodeElt.getLocalName();
            if (name == null) {
                name = nodeElt.getNodeName();
            }
            int result = 0;
            if (namespace != null) {
                result += namespace.hashCode();
            }
            result += name.hashCode();
            NodeList children = nodeElt.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                result += DOMUtils.generateHashCode(children.item(i));
            }
            return result;
        }
        if (node instanceof Attr) {
            Attr nodeAttr = (Attr)node;
            return nodeAttr.getName().hashCode() + nodeAttr.getValue().hashCode();
        }
        if (node instanceof Text) {
            return ((Text)node).getTextContent().hashCode();
        }
        return 0;
    }

    public static HashSet<String> getNamespaces(DOMDocument document) {
        HashSet<String> result = new HashSet<String>();
        DOMElement root = (DOMElement)document.getRootElement();
        ArrayDeque<DOMElement> stack = new ArrayDeque<DOMElement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            DOMElement current = (DOMElement)stack.poll();
            for (Object ch : current.elements()) {
                stack.add((DOMElement)ch);
            }
            result.add(root.getNamespaceURI());
        }
        return result;
    }

    public static void removeUnusedNamespaces(DOMDocument document) {
        HashSet<String> namespaces = DOMUtils.getNamespaces(document);
        ArrayList<Namespace> toRemove = new ArrayList<Namespace>();
        for (Object currentNm : document.getRootElement().declaredNamespaces()) {
            toRemove.add((Namespace)currentNm);
        }
        for (Namespace current : toRemove) {
            current.detach();
        }
    }
}

