/*
 * Decompiled with CFR 0.152.
 */
package xml.schema.utils;

import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import xml.schema.Annotated;
import xml.schema.Attribute;
import xml.schema.ComplexType;
import xml.schema.Element;
import xml.schema.ExplicitGroup;
import xml.schema.LocalElement;
import xml.schema.OpenAttrs;
import xml.schema.Schema;
import xml.schema.SimpleType;
import xml.schema.TopLevelElement;
import xml.schema.utils.ContentType;

public class CachedSchema {
    protected String namespace = null;
    protected HashMap<QName, TopLevelElement> cachedTopLevelElement = new HashMap();
    protected HashMap<QName, Object> elementContents = new HashMap();
    protected HashMap<QName, ContentType> contentTypes = new HashMap();
    protected Schema schema;

    public CachedSchema(Schema schema) {
        this.namespace = schema.getTargetNamespace();
        HashMap<QName, Annotated> annotateds = new HashMap<QName, Annotated>();
        for (OpenAttrs current : schema.getSimpleTypeOrComplexTypeOrGroup()) {
            Annotated currentType;
            QName qname;
            if (current instanceof TopLevelElement) {
                TopLevelElement currentElt = (TopLevelElement)current;
                qname = new QName(this.namespace, currentElt.getName());
                this.cachedTopLevelElement.put(qname, currentElt);
                continue;
            }
            if (current instanceof ComplexType) {
                currentType = (ComplexType)current;
                qname = new QName(this.namespace, ((ComplexType)currentType).getName());
                annotateds.put(qname, currentType);
                continue;
            }
            if (current instanceof SimpleType) {
                currentType = (SimpleType)current;
                qname = new QName(this.namespace, ((SimpleType)currentType).getName());
                annotateds.put(qname, currentType);
                continue;
            }
            if (!(current instanceof Attribute)) continue;
            Attribute currentAtt = (Attribute)current;
            qname = new QName(this.namespace, currentAtt.getName());
            annotateds.put(qname, currentAtt);
        }
        for (TopLevelElement element : this.cachedTopLevelElement.values()) {
            this.processElement(element, null, annotateds);
        }
        this.schema = schema;
    }

    protected void processElement(Element element, QName parentName, HashMap<QName, Annotated> annotateds) {
        Object result = null;
        QName elementName = CachedSchema.generateName(element, parentName, this.namespace);
        QName ref = null;
        Element elt = element;
        do {
            if ((ref = elt.getRef()) == null) continue;
            elt = this.cachedTopLevelElement.get(ref);
        } while (ref != null);
        QName type = elt.getType();
        if (type != null) {
            if (type.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                result = type;
            } else {
                result = annotateds.get(type);
                this.processAnnotated((Annotated)result, elementName, annotateds);
            }
        } else {
            result = elt.getComplexType();
            if (result != null) {
                this.processAnnotated((Annotated)result, elementName, annotateds);
            }
        }
        this.elementContents.put(elementName, result);
    }

    protected void processAnnotated(Annotated annotated, QName elementName, HashMap<QName, Annotated> annotateds) {
        ComplexType type;
        ExplicitGroup gr;
        if (annotated instanceof ComplexType && (gr = this.findGroup(elementName, type = (ComplexType)annotated)) != null) {
            for (Object current : gr.getParticle()) {
                LocalElement element = (LocalElement)((JAXBElement)current).getValue();
                this.processElement(element, elementName, annotateds);
            }
        }
    }

    protected ExplicitGroup findGroup(QName elementName, ComplexType type) {
        ExplicitGroup gr = type.getSequence();
        if (gr != null) {
            this.contentTypes.put(elementName, ContentType.SEQUENCE);
            return gr;
        }
        gr = type.getChoice();
        if (gr != null) {
            this.contentTypes.put(elementName, ContentType.CHOICE);
            return gr;
        }
        gr = type.getAll();
        if (gr != null) {
            this.contentTypes.put(elementName, ContentType.ALL);
            return gr;
        }
        return null;
    }

    public Element getType(QName name) {
        return this.cachedTopLevelElement.get(name);
    }

    public Object getTypeContent(QName elementName) {
        return this.elementContents.get(elementName);
    }

    public Object getTypeContent(String name, String namespace) {
        return this.elementContents.get(new QName(namespace, name));
    }

    public ContentType getContentType(QName annotated) {
        return this.contentTypes.get(annotated);
    }

    public ContentType getContentType(String name, String namespace) {
        return this.contentTypes.get(new QName(namespace, name));
    }

    public static QName generateName(Element element, QName parentName, String namespace) {
        QName elementName = null;
        elementName = parentName == null ? new QName(namespace, element.getName()) : new QName(parentName.getNamespaceURI(), parentName.getLocalPart() + "/" + element.getName());
        return elementName;
    }

    public static JAXBContext getContext() throws JAXBException {
        return JAXBContext.newInstance((String)"xml.schema");
    }

    public Schema getSchema() {
        return this.schema;
    }
}

