/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import org.hamcrest.Description;
import org.hamcrest.IDiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class DiagnosingMatcherAssert {
    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        DiagnosingMatcherAssert.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            if (matcher instanceof IDiagnosingMatcher) {
                ((IDiagnosingMatcher)matcher).describeMismatch(actual, (Description)description);
            } else {
                description.appendValue(actual);
            }
            throw new AssertionError((Object)description.toString());
        }
    }

    public static void assertThat(String reason, boolean assertion) {
        if (!assertion) {
            throw new AssertionError((Object)reason);
        }
    }
}

