/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsEqual;

public class IsArrayContainingInAnyOrder<E>
extends TypeSafeDiagnosingMatcher<E[]> {
    private final IsIterableContainingInAnyOrder<E> iterableMatcher;
    private final Collection<Matcher<? super E>> matchers;

    public IsArrayContainingInAnyOrder(Collection<Matcher<? super E>> matchers) {
        this.iterableMatcher = new IsIterableContainingInAnyOrder(matchers);
        this.matchers = matchers;
    }

    @Override
    public boolean matchesSafely(E[] item, Description mismatchDescription) {
        return this.iterableMatcher.matches(Arrays.asList(item));
    }

    @Override
    public void describeMismatchSafely(E[] item, Description mismatchDescription) {
        this.iterableMatcher.describeMismatch(Arrays.asList(item), mismatchDescription);
    }

    public void describeTo(Description description) {
        description.appendList("[", ", ", "]", this.matchers).appendText(" in any order");
    }

    @Factory
    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Matcher<? super E> ... matchers) {
        return IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(Arrays.asList(matchers));
    }

    @Factory
    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Collection<Matcher<? super E>> matchers) {
        return new IsArrayContainingInAnyOrder<E>(matchers);
    }

    @Factory
    public static <E> Matcher<E[]> arrayContainingInAnyOrder(E ... items) {
        ArrayList<Matcher<Matcher>> matchers = new ArrayList<Matcher<Matcher>>();
        for (E item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return new IsArrayContainingInAnyOrder<E>(matchers);
    }
}

