/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class IsCollectionWithSize<E>
extends FeatureMatcher<Collection<? extends E>, Integer> {
    public IsCollectionWithSize(Matcher<? super Integer> sizeMatcher) {
        super(sizeMatcher, "a collection with size", "collection size");
    }

    @Override
    protected Integer featureValueOf(Collection<? extends E> actual) {
        return actual.size();
    }

    @Factory
    public static <E> Matcher<Collection<? extends E>> hasSize(Matcher<? super Integer> size) {
        return new IsCollectionWithSize<E>(size);
    }

    @Factory
    public static <E> Matcher<Collection<? extends E>> hasSize(int size) {
        Matcher matcher = IsEqual.equalTo((Object)size);
        return IsCollectionWithSize.hasSize((Matcher<? super Integer>)matcher);
    }

    @Override
    public void describeMismatchSafely(Collection<? extends E> item, Description mismatchDescription) {
        mismatchDescription.appendText("size is " + item.size());
    }
}

