/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsEmptyCollection<E>
extends TypeSafeDiagnosingMatcher<Collection<E>> {
    @Override
    public boolean matchesSafely(Collection<E> item, Description mismatchDescription) {
        boolean result = item.isEmpty();
        if (!result) {
            mismatchDescription.appendValue(item);
            mismatchDescription.appendText("is not empty");
        }
        return result;
    }

    @Override
    public void describeMismatchSafely(Collection<E> item, Description mismatchDescription) {
        mismatchDescription.appendValue(item);
    }

    public void describeTo(Description description) {
        description.appendText("an empty collection");
    }

    @Factory
    public static <E> Matcher<Collection<E>> empty() {
        return new IsEmptyCollection<E>();
    }
}

