/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsEmptyIterable<E>
extends TypeSafeDiagnosingMatcher<Iterable<E>> {
    @Override
    public boolean matchesSafely(Iterable<E> iterable, Description mismatchDescription) {
        boolean result;
        boolean bl = result = !iterable.iterator().hasNext();
        if (!result) {
            mismatchDescription.appendValue(iterable);
            mismatchDescription.appendText("is not empty");
        }
        return result;
    }

    @Override
    public void describeMismatchSafely(Iterable<E> iter, Description mismatchDescription) {
        mismatchDescription.appendValueList("[", ",", "]", iter);
    }

    public void describeTo(Description description) {
        description.appendText("an empty iterable");
    }

    @Factory
    public static <E> Matcher<Iterable<E>> emptyIterable() {
        return new IsEmptyIterable<E>();
    }
}

