/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsEmptyMap<K, V>
extends TypeSafeDiagnosingMatcher<Map<K, V>> {
    @Override
    public boolean matchesSafely(Map<K, V> item, Description mismatchDescription) {
        boolean result = item.isEmpty();
        if (!result) {
            mismatchDescription.appendValue(item);
            mismatchDescription.appendText("is not empty");
        }
        return result;
    }

    @Override
    public void describeMismatchSafely(Map<K, V> item, Description mismatchDescription) {
        mismatchDescription.appendValue(item);
    }

    public void describeTo(Description description) {
        description.appendText("an empty collection");
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> empty() {
        return new IsEmptyMap<K, V>();
    }
}

