/*
 * Decompiled with CFR 0.152.
 */
package org.hamsandwich.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.AllOf;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamsandwich.core.Adapter;
import org.hamsandwich.core.CannotAdaptException;
import org.hamsandwich.core.NameResolver;
import org.hamsandwich.core.StackInterrogatingNameResolver;

public abstract class AdaptingMatcher<I, O>
extends TypeSafeMatcher<I>
implements Adapter<I, O> {
    private final String condition;
    private final Matcher<? super O> valueMatcher;
    private final NameResolver entityNameResolver;

    public AdaptingMatcher(Matcher<? super O> ... valueMatchers) {
        this(new GenerifiedClassEntityNameResolver(), new StackInterrogatingNameResolver(), valueMatchers);
    }

    public AdaptingMatcher(String entityName, Matcher<? super O> ... valueMatchers) {
        this(new StaticNameResolver(entityName), new StackInterrogatingNameResolver(), valueMatchers);
    }

    private AdaptingMatcher(NameResolver entityNameResolver, NameResolver conditionNameResolver, Matcher<? super O> ... valueMatchers) {
        this.valueMatcher = AllOf.allOf(valueMatchers);
        this.condition = conditionNameResolver.resolveFor(this);
        this.entityNameResolver = entityNameResolver;
    }

    public boolean matchesSafely(I in) {
        try {
            return this.valueMatcher.matches(this.get(in));
        }
        catch (CannotAdaptException cannotAdaptException) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("[");
        description.appendText(this.entityNameResolver.resolveFor(this) + " where ");
        description.appendText(this.condition);
        description.appendText(" ");
        this.valueMatcher.describeTo(description);
        description.appendText("]");
    }

    public void describeMismatch(Object o, Description description) {
        try {
            if (this.valueMatcher instanceof TypeSafeDiagnosingMatcher) {
                ((TypeSafeDiagnosingMatcher)this.valueMatcher).describeMismatch(this.get(o), description);
            } else {
                description.appendText("was ").appendValue(o);
            }
            return;
        }
        catch (ClassCastException cce) {
        }
        catch (CannotAdaptException cannotAdaptException) {
            // empty catch block
        }
        description.appendText("was ").appendValue(o);
    }

    private static List<Class> getGenerifiedClassesOf(Object o) {
        ParameterizedType genericSuperclass = (ParameterizedType)o.getClass().getGenericSuperclass();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Type type : genericSuperclass.getActualTypeArguments()) {
            Class targetClass = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
            classes.add(targetClass);
        }
        return classes;
    }

    public String toString() {
        StringDescription description = new StringDescription();
        this.describeTo((Description)description);
        return description.toString();
    }

    private static class GenerifiedClassEntityNameResolver
    implements NameResolver {
        private GenerifiedClassEntityNameResolver() {
        }

        @Override
        public String resolveFor(Object object) {
            return "a " + ((Class)AdaptingMatcher.getGenerifiedClassesOf(object).get(0)).getSimpleName();
        }
    }

    private static class StaticNameResolver
    implements NameResolver {
        private final String name;

        public StaticNameResolver(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Can't have a null name for a matcher");
            }
            this.name = name;
        }

        @Override
        public String resolveFor(Object o) {
            return this.name;
        }
    }
}

