/*
 * Decompiled with CFR 0.152.
 */
package org.hamsandwich.core;

import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.AllOf;
import org.hamcrest.Matcher;

public class CollectionFilter<T> {
    private final Matcher<T> combined;

    public CollectionFilter(Matcher<? super T> ... valueMatchers) {
        this.combined = AllOf.allOf(valueMatchers);
    }

    public <T> Iterable<T> select(Iterable<T> subjects) {
        HashSet<T> matches = new HashSet<T>();
        for (T t : subjects) {
            if (!this.combined.matches(t)) continue;
            matches.add(t);
        }
        return matches;
    }

    public <T> Iterable<T> remove(Iterable<T> subjects) {
        HashSet<T> matches = new HashSet<T>();
        for (T t : subjects) {
            if (this.combined.matches(t)) continue;
            matches.add(t);
        }
        return matches;
    }

    public <T> Iterable<T> remove(T[] subjects) {
        return this.remove(Arrays.asList(subjects));
    }

    public <T> Iterable<T> select(T[] subjects) {
        return this.select(Arrays.asList(subjects));
    }

    public static <T> Iterable<T> select(Iterable<T> subjects, Matcher<? super T> ... valueMatchers) {
        return new CollectionFilter<T>(valueMatchers).select(subjects);
    }

    public static <T> Iterable<T> select(T[] subjects, Matcher<? super T> ... valueMatchers) {
        return new CollectionFilter<T>(valueMatchers).select(subjects);
    }

    public static <T> Iterable<T> remove(Iterable<T> subjects, Matcher<? super T> ... valueMatchers) {
        return new CollectionFilter<T>(valueMatchers).remove(subjects);
    }

    public static <T> Iterable<T> remove(T[] subjects, Matcher<? super T> ... valueMatchers) {
        return new CollectionFilter<T>(valueMatchers).remove(subjects);
    }
}

