/*
 * Decompiled with CFR 0.152.
 */
package org.hamsandwich.core;

import org.hamcrest.AllOf;
import org.hamcrest.Matcher;
import org.hamsandwich.core.Adapter;
import org.hamsandwich.core.AdaptingMatcher;
import org.hamsandwich.core.CannotAdaptException;
import org.hamsandwich.core.IsFalseAdaptingMatcher;
import org.hamsandwich.core.IsTrueAdaptingMatcher;

public class HamSandwichMatchers {
    private HamSandwichMatchers() {
    }

    public static <I, O> Matcher<I> adaptingMatcher(final Adapter<I, O> adapter, Matcher<O> ... valueMatchers) {
        return new AdaptingMatcher<I, O>(new Matcher[]{AllOf.allOf(valueMatchers)}){

            @Override
            public O get(I in) throws CannotAdaptException {
                return adapter.get(in);
            }
        };
    }

    public static <I, O> Matcher<I> adaptingMatcher(String entityName, final Adapter<I, O> adapter, Matcher<O> ... valueMatchers) {
        return new AdaptingMatcher<I, O>(entityName, new Matcher[]{AllOf.allOf(valueMatchers)}){

            @Override
            public O get(I in) throws CannotAdaptException {
                return adapter.get(in);
            }
        };
    }

    public static <I> Matcher<I> isTrueAdaptingMatcher(String entityName, final Adapter<I, Boolean> adapter) {
        return new IsTrueAdaptingMatcher<I>(entityName){

            @Override
            public Boolean get(I in) throws CannotAdaptException {
                return (Boolean)adapter.get(in);
            }
        };
    }

    public static <I> Matcher<I> isTrueAdaptingMatcher(final Adapter<I, Boolean> adapter) {
        return new IsTrueAdaptingMatcher<I>(){

            @Override
            public Boolean get(I in) throws CannotAdaptException {
                return (Boolean)adapter.get(in);
            }
        };
    }

    public static <I> Matcher<I> isFalseAdaptingMatcher(String entityName, final Adapter<I, Boolean> adapter) {
        return new IsFalseAdaptingMatcher<I>(entityName){

            @Override
            public Boolean get(I in) throws CannotAdaptException {
                return (Boolean)adapter.get(in);
            }
        };
    }

    public static <I> Matcher<I> isFalseAdaptingMatcher(final Adapter<I, Boolean> adapter) {
        return new IsFalseAdaptingMatcher<I>(){

            @Override
            public Boolean get(I in) throws CannotAdaptException {
                return (Boolean)adapter.get(in);
            }
        };
    }
}

