/*
 * Decompiled with CFR 0.152.
 */
package org.hamsandwich.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.InvocationHandler;
import org.hamcrest.Matcher;
import org.hamsandwich.core.AdaptingMatcher;
import org.hamsandwich.core.CannotAdaptException;
import org.hamsandwich.core.ConcreteClassProxyFactory;

public class ReplayMatcher<I, O>
extends AdaptingMatcher<I, O> {
    private static final ThreadLocal<InvocationReplayer> INVOCATION_REPLAYER = new ThreadLocal();
    private final InvocationReplayer invocationReplayer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> Matcher<I> replayMatcher(O methodCallResult, Matcher<O> ... valueMatchers) {
        try {
            ReplayMatcher.assertThatFunctionHasBeenRecorded();
            ReplayMatcher<I, O> replayMatcher = new ReplayMatcher<I, O>(INVOCATION_REPLAYER.get(), valueMatchers);
            return replayMatcher;
        }
        finally {
            INVOCATION_REPLAYER.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> Matcher<I> replayMatcher(String entityName, O methodCallResult, Matcher<O> ... valueMatchers) {
        try {
            ReplayMatcher.assertThatFunctionHasBeenRecorded();
            ReplayMatcher<I, O> replayMatcher = new ReplayMatcher<I, O>(entityName, INVOCATION_REPLAYER.get(), valueMatchers);
            return replayMatcher;
        }
        finally {
            INVOCATION_REPLAYER.remove();
        }
    }

    private static void assertThatFunctionHasBeenRecorded() {
        if (INVOCATION_REPLAYER.get() == null) {
            throw new IllegalArgumentException("Function was not recorded. Did you pass use the on(Class) factory method to create the functionResult?");
        }
    }

    private ReplayMatcher(InvocationReplayer invocationReplayer, Matcher<? super O> ... valueMatchers) {
        super(invocationReplayer.clazz.getSimpleName(), valueMatchers);
        this.invocationReplayer = invocationReplayer;
    }

    private ReplayMatcher(String entityName, InvocationReplayer invocationReplayer, Matcher<? super O> ... valueMatchers) {
        super(entityName, valueMatchers);
        this.invocationReplayer = invocationReplayer;
    }

    public static <T> T on(final Class<T> clazz) {
        return ConcreteClassProxyFactory.INSTANCE.proxyFor(new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                INVOCATION_REPLAYER.set(new InvocationReplayer(method, objects, clazz));
                if (method.getReturnType().getName().equals("boolean")) {
                    return false;
                }
                if (method.getReturnType().isPrimitive()) {
                    return 0;
                }
                return null;
            }
        }, clazz, new Class[0]);
    }

    @Override
    public O get(I in) throws CannotAdaptException {
        try {
            return (O)this.invocationReplayer.replay(in);
        }
        catch (IllegalAccessException e) {
            throw new CannotAdaptException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CannotAdaptException(e.getMessage());
        }
    }

    private static class InvocationReplayer {
        public final Class clazz;
        private final Method method;
        private final Object[] params;

        public InvocationReplayer(Method method, Object[] params, Class clazz) {
            this.method = method;
            this.params = params;
            this.clazz = clazz;
        }

        public Object replay(Object in) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(in, this.params);
        }
    }
}

