/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils;

import java.lang.reflect.Field;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class HasAttributeWithValue<T>
extends TypeSafeDiagnosingMatcher<T> {
    protected String attributeName;
    protected Matcher<?> subMatcher;

    protected HasAttributeWithValue(String attributeName, Matcher<?> subMatcher) {
        this.attributeName = attributeName;
        this.subMatcher = subMatcher;
    }

    protected Object attributeValueOf(T actual) throws IllegalAccessException, NoSuchFieldException {
        for (Class<?> c = actual.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(this.attributeName);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                return f.get(actual);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                if (c != Object.class) continue;
                throw e;
            }
        }
        return null;
    }

    public void describeTo(Description description) {
        description.appendText("hasAttribute(");
        description.appendValue((Object)this.attributeName);
        description.appendText(", ");
        description.appendDescriptionOf(this.subMatcher);
        description.appendText(")");
    }

    @Override
    public boolean matchesSafely(T item, Description mismatchDescription) {
        try {
            Object value = this.attributeValueOf(item);
            boolean result = this.subMatcher.matches(value);
            if (!result) {
                if (this.subMatcher instanceof TypeSafeDiagnosingMatcher) {
                    ((TypeSafeDiagnosingMatcher)this.subMatcher).describeMismatchSafely(item, mismatchDescription);
                } else {
                    mismatchDescription.appendText(" was ").appendValue(item);
                }
            }
            return result;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return this.noAttributeDescription(mismatchDescription);
        }
        catch (IllegalArgumentException e) {
            return this.noAttributeDescription(mismatchDescription);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private boolean noAttributeDescription(Description mismatchDescription) {
        mismatchDescription.appendText("No such attribute " + this.attributeName);
        return false;
    }

    @Factory
    public static <T> Matcher<T> hasAttribute(String attributeName, Matcher<?> value) {
        return new HasAttributeWithValue<T>(attributeName, value);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Matcher<?> getSubMatcher() {
        return this.subMatcher;
    }

    @Override
    public void describeMismatchSafely(T item, Description mismatchDescription) {
    }
}

