/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsEqual;

public class HasElementsContainingInAnyOrder<T>
extends TypeSafeDiagnosingMatcher<Iterable<? extends T>> {
    private final Collection<Matcher<? super T>> matchers;

    public HasElementsContainingInAnyOrder(Collection<Matcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matchesSafely(Iterable<? extends T> items, Description mismatchDescription) {
        Matching<T> matching = new Matching<T>(this.matchers, mismatchDescription);
        for (T item : items) {
            matching.matches(item);
        }
        return matching.isFinished(items);
    }

    public void describeTo(Description description) {
        description.appendText("iterable over ").appendList("[", ", ", "]", this.matchers).appendText(" in any order");
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> hasElementsInAnyOrder(Matcher<? super E> item) {
        return HasElementsContainingInAnyOrder.hasElementsInAnyOrder(new ArrayList(Arrays.asList(item)));
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> hasElementsInAnyOrder(Matcher<? super T> ... matchers) {
        return HasElementsContainingInAnyOrder.hasElementsInAnyOrder(Arrays.asList(matchers));
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> hasElementsInAnyOrder(T ... items) {
        ArrayList<Matcher<T>> matchers = new ArrayList<Matcher<T>>();
        for (T item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return new HasElementsContainingInAnyOrder<T>(matchers);
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> hasElementsInAnyOrder(Collection<Matcher<? super T>> matchers) {
        return new HasElementsContainingInAnyOrder<T>(matchers);
    }

    @Override
    public void describeMismatchSafely(Iterable<? extends T> item, Description mismatchDescription) {
    }

    private static class Matching<S> {
        private final Collection<Matcher<? super S>> matchers;
        private final Description mismatchDescription;

        public Matching(Collection<Matcher<? super S>> matchers, Description mismatchDescription) {
            this.matchers = new ArrayList<Matcher<S>>(matchers);
            this.mismatchDescription = mismatchDescription;
        }

        public boolean matches(S item) {
            return this.isMatched(item);
        }

        public boolean isFinished(Iterable<? extends S> items) {
            if (this.matchers.isEmpty()) {
                return true;
            }
            this.mismatchDescription.appendText("No item matches: ").appendList("", ", ", "", this.matchers).appendText(" in ").appendValueList("[", ", ", "]", items);
            return false;
        }

        private boolean isMatched(S item) {
            for (Matcher<? super S> matcher : this.matchers) {
                if (!matcher.matches(item)) continue;
                this.matchers.remove(matcher);
                return true;
            }
            return false;
        }
    }
}

