/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsEqual;

public class HasElementsContainingInOrder<E>
extends TypeSafeDiagnosingMatcher<Iterable<? extends E>> {
    private final List<Matcher<? super E>> matchers;

    public HasElementsContainingInOrder(List<Matcher<? super E>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matchesSafely(Iterable<? extends E> iterable, Description mismatchDescription) {
        MatchSeries<E> matchSeries = new MatchSeries<E>(this.matchers, mismatchDescription);
        for (E item : iterable) {
            matchSeries.matches(item);
        }
        return matchSeries.isFinished();
    }

    public void describeTo(Description description) {
        description.appendText("iterable containing ").appendList("[", ", ", "]", this.matchers);
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> hasElementsInOrder(E ... items) {
        ArrayList<Matcher<Matcher>> matchers = new ArrayList<Matcher<Matcher>>();
        for (E item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return HasElementsContainingInOrder.hasElementsInOrder(matchers);
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> hasElementsInOrder(Matcher<? super E> item) {
        return HasElementsContainingInOrder.hasElementsInOrder(new ArrayList<Matcher<? super E>>(Arrays.asList(item)));
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> hasElementsInOrder(Matcher<? super E> ... matchers) {
        List<Matcher<? super E>> matcherList = Arrays.asList(matchers);
        return HasElementsContainingInOrder.hasElementsInOrder(matcherList);
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> hasElementsInOrder(List<Matcher<? super E>> contents) {
        return new HasElementsContainingInOrder<E>(contents);
    }

    @Override
    public void describeMismatchSafely(Iterable<? extends E> item, Description mismatchDescription) {
    }

    private static class MatchSeries<F> {
        protected final List<Matcher<? super F>> matchers;
        protected int nextMatchIx;
        private final Description mismatchDescription;

        public MatchSeries(List<Matcher<? super F>> matchers, Description mismatchDescription) {
            this.mismatchDescription = mismatchDescription;
            if (matchers.isEmpty()) {
                throw new IllegalArgumentException("Should specify at least one expected element");
            }
            this.matchers = matchers;
        }

        public boolean matches(F item) {
            return this.isMatched(item);
        }

        public boolean isFinished() {
            if (this.nextMatchIx < this.matchers.size()) {
                this.mismatchDescription.appendText("No item matched: ").appendDescriptionOf((SelfDescribing)this.matchers.get(this.nextMatchIx));
                return false;
            }
            return true;
        }

        private boolean isMatched(F item) {
            if (this.matchers.size() > this.nextMatchIx) {
                Matcher<? super F> matcher = this.matchers.get(this.nextMatchIx);
                if (matcher.matches(item)) {
                    ++this.nextMatchIx;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

