/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils.mocks;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;

public final class HyperPowerMockito {
    private HyperPowerMockito() {
    }

    public static synchronized <T> T mock(Class<T> type, Answer<?> answer) {
        Object result = PowerMockito.mock(type, answer);
        ArrayList<Field> fields = HyperPowerMockito.getFields(type);
        for (Field currentField : fields) {
            if (!HyperPowerMockito.setSingleton(result, currentField)) continue;
            HyperPowerMockito.setDefaults(result, currentField, currentField.getType());
        }
        return (T)result;
    }

    public static synchronized <T> T mock(Class<T> type, Answer<?> answer, Class<?>[] toBeMocked) {
        Object result = PowerMockito.mock(type, answer);
        HyperPowerMockito.injectMocks(type, result, answer, toBeMocked);
        return (T)result;
    }

    public static synchronized <T> void injectMocks(Class<T> type, T mock, Answer<?> answer, Class<?>[] toBeMocked) {
        ArrayList toMock = new ArrayList(Arrays.asList(toBeMocked));
        ArrayList<Field> fields = HyperPowerMockito.getFields(type);
        for (Field currentField : fields) {
            if (!HyperPowerMockito.setSingleton(mock, currentField) || !HyperPowerMockito.setDefaults(mock, currentField, currentField.getType()) || !toMock.contains(currentField.getType())) continue;
            Whitebox.setInternalState(mock, (String)currentField.getName(), (Object)PowerMockito.mock(currentField.getType(), answer));
        }
    }

    public static synchronized <T> T mock(Class<T> type, Answer<?> answer, Class<?>[] toBeMocked, Object[] toBeInjected) {
        Object result = PowerMockito.mock(type, answer);
        HyperPowerMockito.injectMocks(type, result, answer, toBeMocked, toBeInjected);
        return (T)result;
    }

    public static synchronized <T> void injectMocks(Class<T> type, T mock, Answer<?> answer, Class<?>[] toBeMocked, Object[] toBeInjected) {
        ArrayList<Field> fields = HyperPowerMockito.getFields(type);
        ArrayList toMock = new ArrayList(Arrays.asList(toBeMocked));
        for (Field currentField : fields) {
            Class<?> fieldType = currentField.getType();
            if (!HyperPowerMockito.setSingleton(mock, currentField) || !HyperPowerMockito.setDefaults(mock, currentField, currentField.getType()) || !toMock.contains(fieldType)) continue;
            int index = toMock.indexOf(fieldType);
            Object value = null;
            value = index < toBeInjected.length ? toBeInjected[index] : PowerMockito.mock(currentField.getType(), answer);
            Whitebox.setInternalState(mock, (String)currentField.getName(), (Object)value);
        }
    }

    private static ArrayList<Field> getFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        Class<?> superClass = type.getSuperclass();
        if (!superClass.equals(Object.class)) {
            result.addAll(HyperPowerMockito.getFields(superClass));
        }
        return result;
    }

    private static <T> boolean setDefaults(T instance, Field field, Class<?> fieldType) {
        if (fieldType.equals(HashMap.class)) {
            Whitebox.setInternalState(instance, (String)field.getName(), new HashMap());
            return false;
        }
        if (fieldType.equals(ConcurrentHashMap.class)) {
            Whitebox.setInternalState(instance, (String)field.getName(), new ConcurrentHashMap());
            return false;
        }
        if (fieldType.equals(ArrayList.class)) {
            Whitebox.setInternalState(instance, (String)field.getName(), new ArrayList());
            return false;
        }
        return true;
    }

    private static <T> boolean setSingleton(T instance, Field field) {
        if ("instance".equals(field.getName())) {
            ArrayList<T> list = new ArrayList<T>();
            list.add(instance);
            Whitebox.setInternalState(instance.getClass(), list, (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

