/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.ow2.choreos.xsa.xsb.utils.xml.XMLPrettyPrinter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IsXMLDocumentEquivalent
extends TypeSafeDiagnosingMatcher<Document> {
    protected Document control;
    protected Diff result;

    protected IsXMLDocumentEquivalent(String xml) throws SAXException, IOException, DocumentException {
        this.control = XMLUnit.buildControlDocument((String)xml);
        this.initXMLUnit();
    }

    protected IsXMLDocumentEquivalent(Document doc) {
        this.control = doc;
        this.initXMLUnit();
    }

    protected IsXMLDocumentEquivalent(File xmlFile) throws IOException, SAXException, DocumentException {
        this.control = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileReader(xmlFile)));
        this.initXMLUnit();
    }

    protected IsXMLDocumentEquivalent(ClassLoader loader, String filePath) throws URISyntaxException, IOException, SAXException, DocumentException {
        File c = new File(loader.getResource(filePath).toURI());
        this.control = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileReader(c)));
        this.initXMLUnit();
    }

    protected void initXMLUnit() {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
    }

    public void describeTo(Description description) {
        try {
            description.appendText("similar to " + XMLPrettyPrinter.prettyPrint(this.control));
        }
        catch (TransformerException e) {
            description.appendText("similar to a xml document");
        }
    }

    @Override
    public boolean matchesSafely(Document item, Description mismatchDescription) {
        this.result = XMLUnit.compareXML((Document)this.control, (Document)item);
        boolean matches = this.result.similar();
        if (!matches) {
            this.describeMismatchSafely(item, mismatchDescription);
        }
        return matches;
    }

    @Factory
    public static <T> Matcher<Document> xmlDocumentEquivalent(String xml) throws SAXException, IOException, DocumentException {
        return new IsXMLDocumentEquivalent(xml);
    }

    @Factory
    public static <T> Matcher<Document> xmlDocumentEquivalent(Document control) {
        return new IsXMLDocumentEquivalent(control);
    }

    @Factory
    public static <T> Matcher<Document> xmlDocumentEquivalent(File control) throws IOException, SAXException, DocumentException {
        return new IsXMLDocumentEquivalent(control);
    }

    @Factory
    public static <T> Matcher<Document> xmlDocumentEquivalent(ClassLoader loader, String filePath) throws URISyntaxException, IOException, SAXException, DocumentException {
        return new IsXMLDocumentEquivalent(loader, filePath);
    }

    @Override
    public void describeMismatchSafely(Document item, Description mismatchDescription) {
        if (this.result != null) {
            mismatchDescription.appendText(this.result.toString());
        }
    }
}

