/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.xsa.xsb.utils.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IsXMLElementEquivalent
extends TypeSafeDiagnosingMatcher<Element> {
    protected Document control;
    protected Diff result;

    protected IsXMLElementEquivalent(String xml) throws SAXException, IOException, DocumentException {
        this.control = XMLUnit.buildControlDocument((String)xml);
        this.initXMLUnit();
    }

    protected IsXMLElementEquivalent(Document doc) {
        this.control = doc;
        this.initXMLUnit();
    }

    protected IsXMLElementEquivalent(Element elt) {
        try {
            this.control = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element toControl = (Element)elt.cloneNode(true);
            this.control.adoptNode(toControl);
            this.control.appendChild(toControl);
            this.initXMLUnit();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected IsXMLElementEquivalent(File xmlFile) throws IOException, SAXException, DocumentException {
        this.control = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileReader(xmlFile)));
        this.initXMLUnit();
    }

    protected IsXMLElementEquivalent(ClassLoader loader, String filePath) throws URISyntaxException, IOException, SAXException, DocumentException {
        File c = new File(loader.getResource(filePath).toURI());
        this.control = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileReader(c)));
        this.initXMLUnit();
    }

    protected void initXMLUnit() {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
    }

    public void describeTo(Description description) {
    }

    @Override
    public void describeMismatchSafely(Element item, Description mismatchDescription) {
        if (this.result != null) {
            mismatchDescription.appendText(this.result.toString());
        }
    }

    protected boolean matchesSafely(Element element) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element toTest = (Element)element.cloneNode(true);
            doc.adoptNode(toTest);
            doc.appendChild(toTest);
            this.result = XMLUnit.compareXML((Document)this.control, (Document)doc);
            return this.result.similar();
        }
        catch (TransformerFactoryConfigurationError e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
    }

    @Override
    public boolean matchesSafely(Element item, Description mismatchDescription) {
        boolean matches = false;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element toTest = (Element)item.cloneNode(true);
            doc.adoptNode(toTest);
            doc.appendChild(toTest);
            this.result = XMLUnit.compareXML((Document)this.control, (Document)doc);
            matches = this.result.similar();
        }
        catch (TransformerFactoryConfigurationError e) {
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        if (!matches) {
            this.describeMismatch(item, mismatchDescription);
        }
        return matches;
    }

    @Factory
    public static <T> Matcher<Element> xmlElementEquivalent(String xml) throws SAXException, IOException, DocumentException {
        return new IsXMLElementEquivalent(xml);
    }

    @Factory
    public static <T> Matcher<Element> xmlElementEquivalent(Document control) {
        return new IsXMLElementEquivalent(control);
    }

    @Factory
    public static <T> Matcher<Element> xmlElementEquivalent(Element control) {
        return new IsXMLElementEquivalent(control);
    }

    @Factory
    public static <T> Matcher<Element> xmlElementEquivalent(File control) throws IOException, SAXException, DocumentException {
        return new IsXMLElementEquivalent(control);
    }

    @Factory
    public static <T> Matcher<Element> xmlElementEquivalent(ClassLoader loader, String filePath) throws URISyntaxException, IOException, SAXException, DocumentException {
        return new IsXMLElementEquivalent(loader, filePath);
    }
}

