/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.schema.util;

import java.util.StringTokenizer;

import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class EasyXMLFilter extends XMLFilterImpl {

	private boolean first=true;
	
	private SchemaLocatorImpl schemaLocator = new SchemaLocatorImpl();
	
	private NamespaceMapperImpl namespaceContext = new NamespaceMapperImpl();
	
	public EasyXMLFilter(XMLReader parent) {
		super(parent);
	}

	@Override
	public void startElement(String uri, String localName, String name,
			Attributes atts) throws SAXException {
		if (first){
			String schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
			if (schemaLocation!=null){
				for (StringTokenizer stringTokenizer = new StringTokenizer(schemaLocation); stringTokenizer.hasMoreTokens(); ){
					String schemaUri = stringTokenizer.nextToken();
					if (stringTokenizer.hasMoreTokens()){
						String location = stringTokenizer.nextToken();
						schemaLocator.addSchemaLocation(schemaUri,location);
					}
				}
			}
			first = false;
		}
		super.startElement(uri, localName, name, atts);
	}

	@Override
	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {
		namespaceContext.addNamespace(prefix, uri);
		super.startPrefixMapping(prefix, uri);
	}
	
	
	@Override
	public void startDocument() throws SAXException {
		first = true;
		super.startDocument();
	}

	public SchemaLocatorImpl getSchemaLocator() {
		return schemaLocator;
	}

	public NamespaceMapperImpl getNamespaceMapper() {
		return namespaceContext;
	}

}
