/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.woden.WSDLReader;
import org.apache.woden.WSDLSource;
import org.apache.woden.wsdl20.Description;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.test.util.BaseWSDLSource;
import org.ow2.easywsdl.wsdl.test.util.XSLTConverter;
import org.ow2.easywsdl.wsdl.test.wsdl.WSDLList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PerformancesTest
extends TestCase {
    public void testWSDL4JComparaison() throws org.ow2.easywsdl.wsdl.api.WSDLException, URISyntaxException, WSDLException {
        long totalTimeWSDL4J = 0L;
        long totalTimeEasyWSDL = 0L;
        int nbTests = 0;
        org.ow2.easywsdl.wsdl.api.WSDLReader readerDesc = WSDLFactory.newInstance().newWSDLReader();
        javax.wsdl.xml.WSDLReader readerDef = javax.wsdl.factory.WSDLFactory.newInstance().newWSDLReader();
        readerDef.setFeature("javax.wsdl.verbose", false);
        for (URL wsdl : WSDLList.getWsdls11()) {
            long start = System.currentTimeMillis();
            try {
                org.ow2.easywsdl.wsdl.api.Description desc = readerDesc.read(wsdl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            long middle = System.currentTimeMillis();
            Definition def = readerDef.readWSDL(wsdl.toString());
            long end = System.currentTimeMillis();
            long timeEasyWSDL = middle - start;
            totalTimeEasyWSDL += timeEasyWSDL;
            long timeWSDL4J = end - middle;
            totalTimeWSDL4J += timeWSDL4J;
            ++nbTests;
        }
        Assert.assertTrue((String)"Performance tests are too slow", (totalTimeEasyWSDL / (long)nbTests < 200L ? 1 : 0) != 0);
    }

    public void testWodenComparaison() throws URISyntaxException, IOException, SAXException, ParserConfigurationException, org.ow2.easywsdl.wsdl.api.WSDLException, org.apache.woden.WSDLException, WSDLException {
        long totalTimeWoden = 0L;
        long totalTimeEasyWSDL = 0L;
        int nbTests = 0;
        org.ow2.easywsdl.wsdl.api.WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        WSDLReader readerDef = org.apache.woden.WSDLFactory.newInstance().newWSDLReader();
        for (URL wsdlUrl : WSDLList.getWsdls11()) {
            InputSource easyWsdlInputSource = new InputSource(wsdlUrl.openStream());
            easyWsdlInputSource.setSystemId(wsdlUrl.toString());
            InputSource wodenInputSource = XSLTConverter.getInstance().convert(wsdlUrl);
            long start = System.currentTimeMillis();
            org.ow2.easywsdl.wsdl.api.Description desc = reader.read(easyWsdlInputSource);
            long middle = System.currentTimeMillis();
            Description def = readerDef.readWSDL((WSDLSource)new BaseWSDLSource(wodenInputSource, wsdlUrl.toURI()));
            long end = System.currentTimeMillis();
            long timeEasyWSDL = middle - start;
            totalTimeEasyWSDL += timeEasyWSDL;
            long timeWoden = end - middle;
            totalTimeWoden += timeWoden;
            ++nbTests;
        }
        Assert.assertTrue((String)"Performance tests too slow", (totalTimeEasyWSDL / (long)nbTests < 100L ? 1 : 0) != 0);
    }
}

