/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.w3c.dom.Document;

public class WSDLGenericWriterTest
extends TestCase {
    WSDLFactory wsdlFactory = null;
    WSDLReader genericReader = null;
    WSDLWriter genericWriter = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.wsdlFactory = WSDLFactory.newInstance();
        this.genericReader = this.wsdlFactory.newWSDLReader();
        this.genericWriter = this.wsdlFactory.newWSDLWriter();
    }

    public void testWriterWSDLGeneric_DocumentBaseURIContainingSpaces() throws WSDLException, IOException, URISyntaxException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/with space in name.wsdl");
        Description descFromURL = this.genericReader.read(wsdlURL);
        Assert.assertFalse((String)"The document base URI contains unencoded spaces", (boolean)descFromURL.getDocumentBaseURI().toString().contains(" "));
        Document doc = this.genericWriter.getDocument(descFromURL);
        Assert.assertFalse((String)"The DOM document base URI contains unencoded spaces", (boolean)doc.getDocumentURI().contains(" "));
        Description descFromDoc = this.genericReader.read(doc);
        Assert.assertNotNull((Object)descFromDoc);
        Assert.assertFalse((String)"The document base URI contains unencoded spaces", (boolean)descFromDoc.getDocumentBaseURI().toString().contains(" "));
    }
}

