/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4bpel;

import java.util.Map;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELReader;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELWriter;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.converter.DescriptionConverter;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.inout.WSDL4BPELReaderImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.inout.WSDL4BPELWriterImpl;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;


/**
 * This class is a concrete implementation of the abstract class WSDLFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDL4BPELFactoryImpl extends WSDL4BPELFactory {

    @SuppressWarnings("unchecked")
    @Override
    public Description addBPELElmt2Description(final AbsItfDescription desc) throws WSDL4BPELException {
        Description newDesc = null;
        try {
            newDesc = DescriptionConverter.getIntance().convertDescription(desc);
        } catch (final WSDLException e) {
            throw new WSDL4BPELException(e);
        }
        return newDesc;
    }

    @Override
    public WSDL4BPELReader newWSDLReader() throws WSDL4BPELException {
        return new WSDL4BPELReaderImpl();
    }

    @Override
    public WSDL4BPELReader newWSDLReader(final Map<FeatureConstants, Object> features)
            throws WSDL4BPELException {
        final WSDL4BPELReader reader = new WSDL4BPELReaderImpl();
        ((WSDL4BPELReaderImpl) reader).setFeatures(features);
        return reader;
    }

    @Override
    public WSDL4BPELWriter newWSDLWriter() throws WSDL4BPELException {
        return new WSDL4BPELWriterImpl();
    }

}
