/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4bpel.impl;

import java.util.List;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELElement;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.Include;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.decorator.DecoratorDescriptionImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DescriptionImpl extends
        DecoratorDescriptionImpl<Service, Endpoint, Binding, InterfaceType, Include, Import, Types> implements
        Description {

    /**
	 *
	 */
    private static final long serialVersionUID = 1L;

    private WSDL4BPELElement elmt = null;

    @SuppressWarnings("unchecked")
    public DescriptionImpl(final AbsItfDescription wsdl) throws WSDLException {
        super(wsdl, null);

        AbsItfDescription firstWsdl = wsdl;
        if(wsdl instanceof DecoratorDescriptionImpl) {
        	firstWsdl = ((DecoratorDescriptionImpl)wsdl).getFirstDescription();
        }

        if(firstWsdl instanceof org.ow2.easywsdl.wsdl.api.Description) {
        	this.elmt = new WSDL4BPELElementImpl<AbsItfDescription>(firstWsdl);
        } else {
        	throw new WSDL4BPELException("Impossible to find the correct first description");
        }
    }

    public List<PartnerLinkType> getPartnerLinkTypes() throws WSDL4BPELException {
    	return this.elmt.getPartnerLinkTypes();
    }

    public void addPartnerLinkType(PartnerLinkType plt) throws WSDL4BPELException {
    	this.elmt.addPartnerLinkType(plt);
    }

    public PartnerLinkType removePartnerLinkType(PartnerLinkType plt) throws WSDL4BPELException {
    	return this.elmt.removePartnerLinkType(plt);
    }

    public List<PartnerLinkType> removeAllPartnerLinkTypes() throws WSDL4BPELException {
    	return this.elmt.removeAllPartnerLinkTypes();
    }

}
