/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.ow2.easywsdl.extensions.wsdl4bpel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TRole;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/** 
* @author Nicolas Salatge - eBM WebSourcing
*/
public class PartnerLinkTypeImpl extends AbstractWSDLElementImpl<TPartnerLinkType> implements PartnerLinkType {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private List<Role> roles = new ArrayList<Role>();
	
	private Description description = null;
	
    public PartnerLinkTypeImpl(final TPartnerLinkType plt, final Description desc) {
        super(plt, (AbstractWSDLElementImpl) desc);
        this.description = desc;
        
        for(TRole role: this.model.getRole()) {
        	roles.add(new RoleImpl(role, this));
        }
    }

	/**
	 * @return the desc
	 */
	public Description getDescription() {
		return description;
	}

	public void addRole(Role plt) throws WSDL4BPELException {
		throw new NotImplementedException();
	}

	public List<Role> getRoles() throws WSDL4BPELException {
		return this.roles;
	}

	public List<Role> removeAllRoles() throws WSDL4BPELException {
		throw new NotImplementedException();
	}

	public Role removeRole(Role plt) throws WSDL4BPELException {
		throw new NotImplementedException();
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(String name) {
		this.model.setName(name);
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws WSDLException {
		Map<QName, String> res = new HashMap<QName, String>();
		res =  this.model.getOtherAttributes();
		return res;
	}
	
}
