/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4bpel.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.JAXBElement;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELElement;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.inout.WSDL4BPELReaderImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TExtensibleDocumented;
import org.w3c.dom.Element;

/**
 * Abstract super class for all WSDL Elements, providing some basic
 * common functionality.
 */

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDL4BPELElementImpl<T extends WSDLElement> implements WSDL4BPELElement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected T tag;

	private List<PartnerLinkType> partnerLinkTypes = new ArrayList<PartnerLinkType>();

	public WSDL4BPELElementImpl(final T t) throws WSDL4BPELException {
		this.tag = t;
		try {
			getPartnerLinTypeInAnyDescription();
		} catch (WSDLException e) {
			throw new WSDL4BPELException(e);
		}
	}


	private void getPartnerLinTypeInAnyDescription() throws WSDL4BPELException,
			WSDLException {
		// get partner link in description
		if(this.tag instanceof Description) {
			if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof DescriptionType) {
				// wsdl 2.0
				Iterator<Object> it = ((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().iterator();
				Object part = null;
				while (it.hasNext()) {
					part = it.next();
					// get partner link type
					if (part instanceof Element) {
						if((((Element)part).getLocalName().equals("partnerLinkType"))&&(((Element)part).getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/plnktype"))) {
							WSDL4BPELReaderImpl reader = new WSDL4BPELReaderImpl();
							JAXBElement<TPartnerLinkType> jaxbPlt = reader.convertElement2PartnerLinkType((Element)part);
							
							// change element by jaxb element
							((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().remove(part);
							((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().add(jaxbPlt);
							
							// create partnerLinkType
							this.partnerLinkTypes.add(new PartnerLinkTypeImpl(jaxbPlt.getValue(), (Description) this.tag));
						}
					}
				}
			} else if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof TDefinitions) {
				// wsdl 1.1
				Iterator<Object> it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
				Object part = null;
				while (it.hasNext()) {
					part = it.next();
					// get partner link type
					if (part instanceof Element) {
						if((((Element)part).getLocalName().equals("partnerLinkType"))&&(((Element)part).getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/plnktype"))) {
							WSDL4BPELReaderImpl reader = new WSDL4BPELReaderImpl();
							JAXBElement<TPartnerLinkType> jaxbPlt = reader.convertElement2PartnerLinkType((Element)part);
							
							// change element by jaxb element
							((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
							((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().add(jaxbPlt);
							
							// create partnerLinkType
							this.partnerLinkTypes.add(new PartnerLinkTypeImpl(jaxbPlt.getValue(), (Description) this.tag));
						}
					}
				}
			} 
		}
	}


	public List<PartnerLinkType> getPartnerLinkTypes() throws WSDL4BPELException {
		return this.partnerLinkTypes;
	}

	public void addPartnerLinkType(PartnerLinkType plt) throws WSDL4BPELException {
		throw new NotImplementedException();
	}

	public PartnerLinkType removePartnerLinkType(PartnerLinkType plt) throws WSDL4BPELException {
		throw new NotImplementedException();
	}

	public List<PartnerLinkType> removeAllPartnerLinkTypes() throws WSDL4BPELException {
		throw new NotImplementedException();
	}


}
