/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4bpel.impl.inout;

import java.net.URI;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.dom.DOMSource;

import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELReader;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.WSDL4BPELJAXBContext;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDL4BPELReaderImpl implements WSDL4BPELReader {

	WSDLReader reader = null;
	
	/**
     * The JAXB unique unmarshaller.
     */
    private Unmarshaller unmarshaller = null;

	public WSDL4BPELReaderImpl() throws WSDL4BPELException {
		try {
			WSDLFactory factory = WSDLFactory.newInstance();
			factory.setJAXBObjectFactoryList(WSDL4BPELJAXBContext.getDefaultObjectFactories());
			this.reader = factory.newWSDLReader();
			
			WSDL4BPELJAXBContext.createDefaultContext();
			this.unmarshaller = WSDL4BPELJAXBContext.getJaxbContext().createUnmarshaller();
		} catch (final WSDLException e) {
			throw new WSDL4BPELException(e);
		} catch (JAXBException e) {
			throw new WSDL4BPELException(e);
		}
	}

	public Object getFeature(final FeatureConstants name) {
		return this.reader.getFeature(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.reader.getFeatures();
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		((AbstractWSDLReaderImpl) this.reader).setFeatures(features);
	}

	public Description readBPEL4WSDL(final URI wsdlURI) throws WSDL4BPELException {
		Description res = null;
		try {
			final org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlURI);
			res = WSDL4BPELFactory.newInstance().addBPELElmt2Description(desc);
		} catch (final WSDLException e) {
			throw new WSDL4BPELException(e);
		}
		return res;
	}

	public Description readBPEL4WSDL(final Document wsdlDocument) throws WSDL4BPELException {
		Description res = null;
		try {
			final org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlDocument);
			res = WSDL4BPELFactory.newInstance().addBPELElmt2Description(desc);
		} catch (final WSDLException e) {
			throw new WSDL4BPELException(e);
		}
		return res;
	}

	public Description readBPEL4WSDL(final URI wsdlURI, final DOMSource inputSource) throws WSDL4BPELException {
		Description res = null;
		try {
			final org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlURI,
					inputSource);
			res = WSDL4BPELFactory.newInstance().addBPELElmt2Description(desc);
		} catch (final WSDLException e) {
			throw new WSDL4BPELException(e);
		}
		return res;
	}

	public void setFeature(final FeatureConstants name, final Object value) throws WSDLException {
		this.reader.setFeature(name, value);
	}

	
    public JAXBElement<TPartnerLinkType> convertElement2PartnerLinkType(final Element pltElmt)
    throws WSDLException {
    	JAXBElement<TPartnerLinkType> res = null;
        try {
            res = this.unmarshaller.unmarshal(pltElmt, TPartnerLinkType.class);
        } catch (final JAXBException e) {
            throw new WSDLException(
                    "Failed to build Java bindings from WSDL descriptor XML document", e);
        }
        return res;
    }
}
