/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.api.artifact.lifecycle;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ComponentLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ServiceAssemblyLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.SharedLibraryLifecycle;

public abstract class ArtifactLifecycleFactory {
    public static final String FACTORY_PROPERTY_KEY = "org.ow2.petals.admin.api.artifact.lifecycle.factory";

    public static ArtifactLifecycle newInstance(Artifact a) {
        ArtifactLifecycleFactory f;
        String className = System.getProperty(FACTORY_PROPERTY_KEY);
        try {
            f = (ArtifactLifecycleFactory)ReflectionHelper.newInstance((String)className, null, (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException((Throwable)e);
        }
        if (a instanceof Component) {
            return f.createComponentLifecycle((Component)a);
        }
        if (a instanceof ServiceAssembly) {
            return f.createServiceAssemblyLifecycle((ServiceAssembly)a);
        }
        if (a instanceof SharedLibrary) {
            return f.createSharedLibraryLifecycle((SharedLibrary)a);
        }
        throw new UncheckedException("Unknow artifact type");
    }

    public abstract ComponentLifecycle createComponentLifecycle(Component var1);

    public abstract ServiceAssemblyLifecycle createServiceAssemblyLifecycle(ServiceAssembly var1);

    public abstract SharedLibraryLifecycle createSharedLibraryLifecycle(SharedLibrary var1);
}

