/****************************************************************************
 *
 *  Copyright (C) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api;

import java.lang.reflect.InvocationTargetException;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;

/**
 * 
 * @author "Mathieu CARROLLE - EBM WebSourcing"
 * 
 */
public abstract class AdminFactory {

    /**
     * Property key to set {@link AdminFactory} implementation name
     */
    public static final String FACTORY_PROPERTY_KEY = "org.ow2.petals.admin.api.factory";

    /**
     * Obtain a new instance of {@link AdminFactory}. The implementation's class
     * to load is found by getting the value of the system property :
     * org.ow2.petals.admin.api.factory
     * 
     * @return The implementation of the factory class.
     */
    public static AdminFactory newInstance() {
        String className = System.getProperty(FACTORY_PROPERTY_KEY);
        try {
            return ReflectionHelper.newInstance(className, null);
        } catch (InvocationTargetException e) {
            throw new UncheckedException(e);
        }
    }

    /**
     * Create instance of {@link ArtifactAdministration} implementation.
     * 
     * @return an {@link ArtifactAdministration} instance.
     */
    public abstract ArtifactAdministration createArtifactAdministration();

    /**
     * Create instance of {@link ContainerAdministration} implementation.
     * 
     * @return an {@link ContainerAdministration} instance.
     */
    public abstract ContainerAdministration createContainerAdministration();

    /**
     * Create instance of {@link RegistryAdministration} implementation.
     * 
     * @return an {@link RegistryAdministration} instance.
     */
    public abstract RegistryAdministration createRegistryAdministration();
}
