/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api;

import java.util.List;
import java.util.Properties;

import org.ow2.petals.admin.api.artifact.Logger;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.admin.api.exception.InvalidLogLevelException;
import org.ow2.petals.admin.api.exception.LoggerNotFoundException;
import org.ow2.petals.admin.topology.Domain;

/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public interface ContainerAdministration {

    public void connect(String host, int port, String user, String password)
            throws ContainerAdministrationException;

    public void disconnect() throws ContainerAdministrationException;

    public String getSystemInfo() throws ContainerAdministrationException;

    public void stopContainer() throws ContainerAdministrationException;

    public void shutdownContainer() throws ContainerAdministrationException;

    public Domain getTopology() throws ContainerAdministrationException;

    public Properties getServerProperties() throws ContainerAdministrationException;

    /**
     * Change the level of a logger.
     * 
     * @param loggerName
     *            The logger for which the level will be updated.
     * @param loggerLevel
     *            The level to set to the logger
     * @throws InvalidLogLevelException
     *             The level is invalid (does not exist).
     * @throws LoggerNotFoundException
     *             The logger does not exist.
     * @throws ContainerAdministrationException
     *             An error occurs updating the logger level.
     */
    public void changeLoggerLevel(String loggerName, String loggerLevel)
            throws InvalidLogLevelException, LoggerNotFoundException,
            ContainerAdministrationException;

    /**
     * Get loggers available on the container.
     * 
     * @return The list of loggers available on the container.
     * @throws ContainerAdministrationException
     *             An error occurs getting loggers.
     */
    public List<Logger> getLoggers() throws ContainerAdministrationException;
}
