/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api;

import org.ow2.petals.admin.api.exception.RegistryAdministrationException;
import org.ow2.petals.admin.api.exception.RegistryRegexpPatternException;
import org.ow2.petals.admin.registry.RegistryView;

/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public interface RegistryAdministration {

    public void synchronizeRegistry() throws RegistryAdministrationException;
    
    public void synchronizeRegistryOnAllNodes() throws RegistryAdministrationException;
        
    /**
     * Return the registry content filtered according to the provided regular
     * expressions.
     * 
     * @param endpointNameRegex
     *            A regexp filtering endpoint name, cannot be <code>null</code>.
     * @param serviceNameRegex
     *            A regexp filtering service name, cannot be <code>null</code>.
     * @param interfaceNameRegex
     *            A regexp filtering interface name, cannot be <code>null</code>.
     * @return The registry content filtered.
     * @throws RegistryRegexpPatternException
     *             A regexp is invalid
     * @throws RegistryAdministrationException
     *             An error occurs getting the registry content.
     */
    public RegistryView getRegistryContent(String endpointNameRegex, String serviceNameRegex,
            String interfaceNameRegex) throws RegistryRegexpPatternException,
            RegistryAdministrationException;
    
}
