/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api.artifact;


/**
 * This class represents a remote JBI artifact archive.
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public abstract class Artifact {

    private final String name;

    private final String version;

    private final String type;

    /**
     * Create a new artifact
     * 
     * @param name
     *            the name of the artifact
     * 
     */
    protected Artifact(String name, String type) {
        this(name, null, type);
    }

    /**
     * Create a new artifact
     * 
     * @param name
     *            the name of the artifact
     * @param version
     *            the version of the artifact
     */
    protected Artifact(String name, String version, String type) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    /**
     * Return the type of the artifact.
     * 
     * @return the type of the artifact.
     */
    public String getType() {
        return type;
    }

    /**
     * Return the name of the artifact
     * 
     * @return the name of the artifact
     */
    public String getName() {
        return this.name;
    }

    /**
     * Return the version of the artifact
     * 
     * @return the version of the artifact
     */
    public String getVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        result = prime * result + ((version == null) ? 0 : version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Artifact other = (Artifact) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (type == null) {
            if (other.type != null)
                return false;
        } else if (!type.equals(other.type))
            return false;
        if (version == null) {
            if (other.version != null)
                return false;
        } else if (!version.equals(other.version))
            return false;
        return true;
    }

}
