
package org.ow2.petals.admin.api.artifact;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public interface ArtifactState {

    public enum State {
        STARTED("Started"), STOPPED("Stopped"), SHUTDOWN("Shutdown"), UNKNOWN("Unknown");

        private final String value;

        State(String value) {
            this.value = value;
        }

        public static final State fromStringValue(String stringValue) {
            for (State state : State.values()) {
                if (stringValue.equals(state.value)) {
                    return state;
                }
            }
            throw new UncheckedException(String.format("Unknown state for value '%s'", stringValue));
        }

    };

    public State getState();

    public void setState(State state);
}
