/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api.artifact;

import java.util.Properties;

/**
 * This class represents a remote JBI Component.
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class Component extends Artifact implements ArtifactState {

    public enum ComponentType {
        BC, SE
    };

    private ComponentType type;

    private Properties parameters;

    private State state;

    public Component(String name, ComponentType type, Properties parameters) {
        super(name, type.toString());
        this.type = type;
        this.parameters = parameters;
        this.state = State.UNKNOWN;
    }

    public Component(String name, ComponentType type) {
        this(name, type, new Properties());
    }

    /**
     * Get the component type
     * 
     * @return the component type
     */
    public final ComponentType getComponentType() {
        return this.type;
    }

    /**
     * Get the parameters
     * 
     * @return the parameters
     */
    public final Properties getParameters() {
        return this.parameters;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public void setState(State state) {
        this.state = state;
    }

}
