/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api.artifact;

import java.util.ArrayList;
import java.util.List;

/**
 * This class represents a remote JBI service assembly.
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class ServiceAssembly extends Artifact implements ArtifactState {

    public static final String TYPE = "SA";

    /**
     * XPath expression to access service units names
     */
    public static final String XPATH_JBI_SU_NAMES = "/*[local-name()='jbi']/*[local-name()='service-assembly']/*[local-name()='service-unit']/*[local-name()='identification']/*[local-name()='name']";

    /**
     * XPath expression to access components dependencies
     */
    public static final String XPATH_JBI_SU_COMPONENTS = "/*[local-name()='jbi']/*[local-name()='service-assembly']/*[local-name()='service-unit']/*[local-name()='target']/*[local-name()='component-name']";

    private State state;

    private List<ServiceUnit> serviceUnits;

    public ServiceAssembly(String name) {
        this(name, new ArrayList<ServiceUnit>());
    }

    public ServiceAssembly(String name, List<ServiceUnit> serviceUnits) {
        super(name, TYPE);
        this.state = State.UNKNOWN;
        this.serviceUnits = serviceUnits;
    }

    public List<ServiceUnit> getServiceUnits() {
        return serviceUnits;
    }

    /**
     * Update the service assembly state
     * 
     * @param the
     *            service assembly state
     */
    public void setState(State state) {
        this.state = state;
    }

    /**
     * Get the service assembly state
     * 
     * @return the service assembly state
     */
    public State getState() {
        return state;
    }

}
