package org.ow2.petals.admin.api.artifact.lifecycle;

import java.net.URL;

import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;

public interface ArtifactLifecycle {

    /**
     * Install/deploy the artefact
     */
    public void deploy(URL artifactUrl) throws ArtifactAdministrationException;

    /**
     * Start the artefact
     */
    public void start() throws ArtifactAdministrationException;

    /**
     * Stop the artefact
     */
    public void stop() throws ArtifactAdministrationException;

    /**
     * Undeploy the artefact
     */
    public void undeploy() throws ArtifactAdministrationException;

    /**
     * Shutdown the artefact
     */
    public void shutdown() throws ArtifactAdministrationException;
    
    /**
     * Update the state of the artefact (if there is one)
     */
    public void updateState() throws ArtifactAdministrationException;
}
