
package org.ow2.petals.admin.api.artifact.lifecycle;

import java.lang.reflect.InvocationTargetException;

import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;

public abstract class ArtifactLifecycleFactory {

    public final static String FACTORY_PROPERTY_KEY = "org.ow2.petals.admin.api.artifact.lifecycle.factory";

    /**
     * 
     * @param a
     * @return
     */
    public static ArtifactLifecycle newInstance(Artifact a) {
        String className = System.getProperty(FACTORY_PROPERTY_KEY);
        ArtifactLifecycleFactory f;
        try {
            f = ReflectionHelper.newInstance(className, null);
        } catch (InvocationTargetException e) {
            throw new UncheckedException(e);
        }
        if (a instanceof Component) {
            return f.createComponentLifecycle((Component) a);
        } else if (a instanceof ServiceAssembly) {
            return f.createServiceAssemblyLifecycle((ServiceAssembly) a);
        } else if (a instanceof SharedLibrary) {
            return f.createSharedLibraryLifecycle((SharedLibrary) a);
        } else {
            throw new UncheckedException("Unknow artifact type");
        }
    }

    public abstract ComponentLifecycle createComponentLifecycle(Component c);

    public abstract ServiceAssemblyLifecycle createServiceAssemblyLifecycle(ServiceAssembly sa);

    public abstract SharedLibraryLifecycle createSharedLibraryLifecycle(SharedLibrary sl);
}
