/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api.exception;

/**
 * Several artifacts match the name, the artifact type MUST be provided to be able to find the right artifact.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class ArtifactTypeIsNeededException extends ArtifactAdministrationException {

    private static final long serialVersionUID = -4776542238872815390L;

    /**
     * The artifact name matching several artifacts.
     */
    private final String name;
    
    public ArtifactTypeIsNeededException(final String name) {
        super(String.format("%s: is not a unique identifier", name));
        this.name = name;
    }

    /**
     * @return  The artifact name matching several artifacts.
     */
    public String getName() {
        return this.name;
    }
}
