/****************************************************************************
 *
 *  Copyright (c) 2012, EBM WebSourcing
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/

package org.ow2.petals.admin.api.exception;

/**
 * The level is invalid (does not exist).
 * 
 * @author Christophe DENUEX - Linagora
 */
public class InvalidLogLevelException extends ContainerAdministrationException {
    
    private static final long serialVersionUID = -6677503188175236576L;

    /**
     * The invalid level
     */
    private final String level;

    public InvalidLogLevelException(final String level) {
        super(String.format("Invalid level: %s", level));
        this.level = level;
    }

    /**
     * @return The invalid level
     */
    public String getLevel() {
        return this.level;
    }
}
